/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codecommit.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.codecommit.model.BatchGetRepositoriesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class BatchGetRepositoriesRequestMarshaller
implements Marshaller<Request<BatchGetRepositoriesRequest>, BatchGetRepositoriesRequest> {
    @Override
    public Request<BatchGetRepositoriesRequest> marshall(BatchGetRepositoriesRequest batchGetRepositoriesRequest) {
        if (batchGetRepositoriesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetRepositoriesRequest> request = new DefaultRequest<BatchGetRepositoriesRequest>(batchGetRepositoriesRequest, "AWSCodeCommit");
        request.addHeader("X-Amz-Target", "CodeCommit_20150413.BatchGetRepositories");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> repositoryNamesList = batchGetRepositoriesRequest.getRepositoryNames();
            if (repositoryNamesList != null) {
                jsonWriter.key("repositoryNames");
                jsonWriter.array();
                for (String repositoryNamesListValue : repositoryNamesList) {
                    if (repositoryNamesListValue == null) continue;
                    jsonWriter.value(repositoryNamesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

