/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.OutputLogEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetLogEventsResult
implements Serializable,
Cloneable {
    private SdkInternalList<OutputLogEvent> events;
    private String nextForwardToken;
    private String nextBackwardToken;

    public List<OutputLogEvent> getEvents() {
        if (this.events == null) {
            this.events = new SdkInternalList();
        }
        return this.events;
    }

    public void setEvents(Collection<OutputLogEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new SdkInternalList<OutputLogEvent>(events);
    }

    public GetLogEventsResult withEvents(OutputLogEvent ... events) {
        if (this.events == null) {
            this.setEvents(new SdkInternalList<OutputLogEvent>(events.length));
        }
        for (OutputLogEvent ele : events) {
            this.events.add(ele);
        }
        return this;
    }

    public GetLogEventsResult withEvents(Collection<OutputLogEvent> events) {
        this.setEvents(events);
        return this;
    }

    public void setNextForwardToken(String nextForwardToken) {
        this.nextForwardToken = nextForwardToken;
    }

    public String getNextForwardToken() {
        return this.nextForwardToken;
    }

    public GetLogEventsResult withNextForwardToken(String nextForwardToken) {
        this.setNextForwardToken(nextForwardToken);
        return this;
    }

    public void setNextBackwardToken(String nextBackwardToken) {
        this.nextBackwardToken = nextBackwardToken;
    }

    public String getNextBackwardToken() {
        return this.nextBackwardToken;
    }

    public GetLogEventsResult withNextBackwardToken(String nextBackwardToken) {
        this.setNextBackwardToken(nextBackwardToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getNextForwardToken() != null) {
            sb.append("NextForwardToken: " + this.getNextForwardToken() + ",");
        }
        if (this.getNextBackwardToken() != null) {
            sb.append("NextBackwardToken: " + this.getNextBackwardToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLogEventsResult)) {
            return false;
        }
        GetLogEventsResult other = (GetLogEventsResult)obj;
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getNextForwardToken() == null ^ this.getNextForwardToken() == null) {
            return false;
        }
        if (other.getNextForwardToken() != null && !other.getNextForwardToken().equals(this.getNextForwardToken())) {
            return false;
        }
        if (other.getNextBackwardToken() == null ^ this.getNextBackwardToken() == null) {
            return false;
        }
        return other.getNextBackwardToken() == null || other.getNextBackwardToken().equals(this.getNextBackwardToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getNextForwardToken() == null ? 0 : this.getNextForwardToken().hashCode());
        hashCode = 31 * hashCode + (this.getNextBackwardToken() == null ? 0 : this.getNextBackwardToken().hashCode());
        return hashCode;
    }

    public GetLogEventsResult clone() {
        try {
            return (GetLogEventsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

