/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

public class CreateElasticsearchDomainRequestMarshaller
implements Marshaller<Request<CreateElasticsearchDomainRequest>, CreateElasticsearchDomainRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateElasticsearchDomainRequest> marshall(CreateElasticsearchDomainRequest createElasticsearchDomainRequest) {
        if (createElasticsearchDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateElasticsearchDomainRequest> request = new DefaultRequest<CreateElasticsearchDomainRequest>(createElasticsearchDomainRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/es/domain";
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> advancedOptionsMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createElasticsearchDomainRequest.getDomainName() != null) {
                jsonWriter.key("DomainName").value(createElasticsearchDomainRequest.getDomainName());
            }
            if (createElasticsearchDomainRequest.getElasticsearchClusterConfig() != null) {
                jsonWriter.key("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(createElasticsearchDomainRequest.getElasticsearchClusterConfig(), jsonWriter);
            }
            if (createElasticsearchDomainRequest.getEBSOptions() != null) {
                jsonWriter.key("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(createElasticsearchDomainRequest.getEBSOptions(), jsonWriter);
            }
            if (createElasticsearchDomainRequest.getAccessPolicies() != null) {
                jsonWriter.key("AccessPolicies").value(createElasticsearchDomainRequest.getAccessPolicies());
            }
            if (createElasticsearchDomainRequest.getSnapshotOptions() != null) {
                jsonWriter.key("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(createElasticsearchDomainRequest.getSnapshotOptions(), jsonWriter);
            }
            if ((advancedOptionsMap = createElasticsearchDomainRequest.getAdvancedOptions()) != null) {
                jsonWriter.key("AdvancedOptions");
                jsonWriter.object();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonWriter.key(advancedOptionsMapValue.getKey());
                    jsonWriter.value(advancedOptionsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

