/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.logs.model.MetricFilter;
import com.amazonaws.services.logs.model.MetricTransformation;
import com.amazonaws.services.logs.model.transform.MetricTransformationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class MetricFilterJsonMarshaller {
    private static MetricFilterJsonMarshaller instance;

    public void marshall(MetricFilter metricFilter, JSONWriter jsonWriter) {
        if (metricFilter == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList metricTransformationsList;
            jsonWriter.object();
            if (metricFilter.getFilterName() != null) {
                jsonWriter.key("filterName").value(metricFilter.getFilterName());
            }
            if (metricFilter.getFilterPattern() != null) {
                jsonWriter.key("filterPattern").value(metricFilter.getFilterPattern());
            }
            if (!(metricTransformationsList = (SdkInternalList)metricFilter.getMetricTransformations()).isEmpty() || !metricTransformationsList.isAutoConstruct()) {
                jsonWriter.key("metricTransformations");
                jsonWriter.array();
                for (MetricTransformation metricTransformationsListValue : metricTransformationsList) {
                    if (metricTransformationsListValue == null) continue;
                    MetricTransformationJsonMarshaller.getInstance().marshall(metricTransformationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (metricFilter.getCreationTime() != null) {
                jsonWriter.key("creationTime").value(metricFilter.getCreationTime());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MetricFilterJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MetricFilterJsonMarshaller();
        }
        return instance;
    }
}

