/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.Step;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopStepConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStatusJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class StepJsonMarshaller {
    private static StepJsonMarshaller instance;

    public void marshall(Step step, JSONWriter jsonWriter) {
        if (step == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (step.getId() != null) {
                jsonWriter.key("Id").value(step.getId());
            }
            if (step.getName() != null) {
                jsonWriter.key("Name").value(step.getName());
            }
            if (step.getConfig() != null) {
                jsonWriter.key("Config");
                HadoopStepConfigJsonMarshaller.getInstance().marshall(step.getConfig(), jsonWriter);
            }
            if (step.getActionOnFailure() != null) {
                jsonWriter.key("ActionOnFailure").value(step.getActionOnFailure());
            }
            if (step.getStatus() != null) {
                jsonWriter.key("Status");
                StepStatusJsonMarshaller.getInstance().marshall(step.getStatus(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepJsonMarshaller();
        }
        return instance;
    }
}

