/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.opsworks.model.DeleteInstanceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class DeleteInstanceRequestMarshaller
implements Marshaller<Request<DeleteInstanceRequest>, DeleteInstanceRequest> {
    @Override
    public Request<DeleteInstanceRequest> marshall(DeleteInstanceRequest deleteInstanceRequest) {
        if (deleteInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteInstanceRequest> request = new DefaultRequest<DeleteInstanceRequest>(deleteInstanceRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DeleteInstance");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deleteInstanceRequest.getInstanceId() != null) {
                jsonWriter.key("InstanceId").value(deleteInstanceRequest.getInstanceId());
            }
            if (deleteInstanceRequest.getDeleteElasticIp() != null) {
                jsonWriter.key("DeleteElasticIp").value(deleteInstanceRequest.getDeleteElasticIp());
            }
            if (deleteInstanceRequest.getDeleteVolumes() != null) {
                jsonWriter.key("DeleteVolumes").value(deleteInstanceRequest.getDeleteVolumes());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

