/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.App;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.EnvironmentVariable;
import com.amazonaws.services.opsworks.model.transform.DataSourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.EnvironmentVariableJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SslConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class AppJsonMarshaller {
    private static AppJsonMarshaller instance;

    public void marshall(App app, JSONWriter jsonWriter) {
        if (app == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList environmentList;
            SdkInternalMap attributesMap;
            SdkInternalList domainsList;
            SdkInternalList dataSourcesList;
            jsonWriter.object();
            if (app.getAppId() != null) {
                jsonWriter.key("AppId").value(app.getAppId());
            }
            if (app.getStackId() != null) {
                jsonWriter.key("StackId").value(app.getStackId());
            }
            if (app.getShortname() != null) {
                jsonWriter.key("Shortname").value(app.getShortname());
            }
            if (app.getName() != null) {
                jsonWriter.key("Name").value(app.getName());
            }
            if (app.getDescription() != null) {
                jsonWriter.key("Description").value(app.getDescription());
            }
            if (!(dataSourcesList = (SdkInternalList)app.getDataSources()).isEmpty() || !dataSourcesList.isAutoConstruct()) {
                jsonWriter.key("DataSources");
                jsonWriter.array();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    DataSourceJsonMarshaller.getInstance().marshall(dataSourcesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (app.getType() != null) {
                jsonWriter.key("Type").value(app.getType());
            }
            if (app.getAppSource() != null) {
                jsonWriter.key("AppSource");
                SourceJsonMarshaller.getInstance().marshall(app.getAppSource(), jsonWriter);
            }
            if (!(domainsList = (SdkInternalList)app.getDomains()).isEmpty() || !domainsList.isAutoConstruct()) {
                jsonWriter.key("Domains");
                jsonWriter.array();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonWriter.value(domainsListValue);
                }
                jsonWriter.endArray();
            }
            if (app.getEnableSsl() != null) {
                jsonWriter.key("EnableSsl").value(app.getEnableSsl());
            }
            if (app.getSslConfiguration() != null) {
                jsonWriter.key("SslConfiguration");
                SslConfigurationJsonMarshaller.getInstance().marshall(app.getSslConfiguration(), jsonWriter);
            }
            if (!(attributesMap = (SdkInternalMap)app.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (app.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value(app.getCreatedAt());
            }
            if (!(environmentList = (SdkInternalList)app.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonWriter.key("Environment");
                jsonWriter.array();
                for (EnvironmentVariable environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    EnvironmentVariableJsonMarshaller.getInstance().marshall(environmentListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AppJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AppJsonMarshaller();
        }
        return instance;
    }
}

