/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        String qos;
        if (publishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PublishRequest> request = new DefaultRequest<PublishRequest>(publishRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/topics/{topic}";
        uriResourcePath = uriResourcePath.replace("{topic}", publishRequest.getTopic() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(publishRequest.getTopic()));
        request.setResourcePath(uriResourcePath);
        String string = qos = publishRequest.getQos() == null ? null : StringUtils.fromInteger(publishRequest.getQos());
        if (qos != null) {
            request.addParameter("qos", qos);
        }
        request.setContent(BinaryUtils.toStream(publishRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

