/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.iot.model.DynamoDBAction;
import com.amazonaws.util.json.JSONWriter;

public class DynamoDBActionJsonMarshaller {
    private static DynamoDBActionJsonMarshaller instance;

    public void marshall(DynamoDBAction dynamoDBAction, JSONWriter jsonWriter) {
        if (dynamoDBAction == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (dynamoDBAction.getTableName() != null) {
                jsonWriter.key("tableName").value(dynamoDBAction.getTableName());
            }
            if (dynamoDBAction.getRoleArn() != null) {
                jsonWriter.key("roleArn").value(dynamoDBAction.getRoleArn());
            }
            if (dynamoDBAction.getHashKeyField() != null) {
                jsonWriter.key("hashKeyField").value(dynamoDBAction.getHashKeyField());
            }
            if (dynamoDBAction.getHashKeyValue() != null) {
                jsonWriter.key("hashKeyValue").value(dynamoDBAction.getHashKeyValue());
            }
            if (dynamoDBAction.getRangeKeyField() != null) {
                jsonWriter.key("rangeKeyField").value(dynamoDBAction.getRangeKeyField());
            }
            if (dynamoDBAction.getRangeKeyValue() != null) {
                jsonWriter.key("rangeKeyValue").value(dynamoDBAction.getRangeKeyValue());
            }
            if (dynamoDBAction.getPayloadField() != null) {
                jsonWriter.key("payloadField").value(dynamoDBAction.getPayloadField());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DynamoDBActionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DynamoDBActionJsonMarshaller();
        }
        return instance;
    }
}

