/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.RemoveAttributesFromFindingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class RemoveAttributesFromFindingsRequestMarshaller
implements Marshaller<Request<RemoveAttributesFromFindingsRequest>, RemoveAttributesFromFindingsRequest> {
    @Override
    public Request<RemoveAttributesFromFindingsRequest> marshall(RemoveAttributesFromFindingsRequest removeAttributesFromFindingsRequest) {
        if (removeAttributesFromFindingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RemoveAttributesFromFindingsRequest> request = new DefaultRequest<RemoveAttributesFromFindingsRequest>(removeAttributesFromFindingsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.RemoveAttributesFromFindings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> attributeKeysList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> findingArnsList = removeAttributesFromFindingsRequest.getFindingArns();
            if (findingArnsList != null) {
                jsonWriter.key("findingArns");
                jsonWriter.array();
                for (String findingArnsListValue : findingArnsList) {
                    if (findingArnsListValue == null) continue;
                    jsonWriter.value(findingArnsListValue);
                }
                jsonWriter.endArray();
            }
            if ((attributeKeysList = removeAttributesFromFindingsRequest.getAttributeKeys()) != null) {
                jsonWriter.key("attributeKeys");
                jsonWriter.array();
                for (String attributeKeysListValue : attributeKeysList) {
                    if (attributeKeysListValue == null) continue;
                    jsonWriter.value(attributeKeysListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

