/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.transform.ConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class InstanceGroupConfigJsonMarshaller {
    private static InstanceGroupConfigJsonMarshaller instance;

    public void marshall(InstanceGroupConfig instanceGroupConfig, JSONWriter jsonWriter) {
        if (instanceGroupConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList configurationsList;
            jsonWriter.object();
            if (instanceGroupConfig.getName() != null) {
                jsonWriter.key("Name").value(instanceGroupConfig.getName());
            }
            if (instanceGroupConfig.getMarket() != null) {
                jsonWriter.key("Market").value(instanceGroupConfig.getMarket());
            }
            if (instanceGroupConfig.getInstanceRole() != null) {
                jsonWriter.key("InstanceRole").value(instanceGroupConfig.getInstanceRole());
            }
            if (instanceGroupConfig.getBidPrice() != null) {
                jsonWriter.key("BidPrice").value(instanceGroupConfig.getBidPrice());
            }
            if (instanceGroupConfig.getInstanceType() != null) {
                jsonWriter.key("InstanceType").value(instanceGroupConfig.getInstanceType());
            }
            if (instanceGroupConfig.getInstanceCount() != null) {
                jsonWriter.key("InstanceCount").value(instanceGroupConfig.getInstanceCount());
            }
            if (!(configurationsList = (SdkInternalList)instanceGroupConfig.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonWriter.key("Configurations");
                jsonWriter.array();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static InstanceGroupConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new InstanceGroupConfigJsonMarshaller();
        }
        return instance;
    }
}

