/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.ecs.AmazonECS;
import com.amazonaws.services.ecs.model.ClientException;
import com.amazonaws.services.ecs.model.ClusterContainsContainerInstancesException;
import com.amazonaws.services.ecs.model.ClusterContainsServicesException;
import com.amazonaws.services.ecs.model.ClusterNotFoundException;
import com.amazonaws.services.ecs.model.CreateClusterRequest;
import com.amazonaws.services.ecs.model.CreateClusterResult;
import com.amazonaws.services.ecs.model.CreateServiceRequest;
import com.amazonaws.services.ecs.model.CreateServiceResult;
import com.amazonaws.services.ecs.model.DeleteClusterRequest;
import com.amazonaws.services.ecs.model.DeleteClusterResult;
import com.amazonaws.services.ecs.model.DeleteServiceRequest;
import com.amazonaws.services.ecs.model.DeleteServiceResult;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.DeregisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DeregisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeClustersRequest;
import com.amazonaws.services.ecs.model.DescribeClustersResult;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesRequest;
import com.amazonaws.services.ecs.model.DescribeContainerInstancesResult;
import com.amazonaws.services.ecs.model.DescribeServicesRequest;
import com.amazonaws.services.ecs.model.DescribeServicesResult;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.DescribeTaskDefinitionResult;
import com.amazonaws.services.ecs.model.DescribeTasksRequest;
import com.amazonaws.services.ecs.model.DescribeTasksResult;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointRequest;
import com.amazonaws.services.ecs.model.DiscoverPollEndpointResult;
import com.amazonaws.services.ecs.model.InvalidParameterException;
import com.amazonaws.services.ecs.model.ListClustersRequest;
import com.amazonaws.services.ecs.model.ListClustersResult;
import com.amazonaws.services.ecs.model.ListContainerInstancesRequest;
import com.amazonaws.services.ecs.model.ListContainerInstancesResult;
import com.amazonaws.services.ecs.model.ListServicesRequest;
import com.amazonaws.services.ecs.model.ListServicesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionFamiliesResult;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsRequest;
import com.amazonaws.services.ecs.model.ListTaskDefinitionsResult;
import com.amazonaws.services.ecs.model.ListTasksRequest;
import com.amazonaws.services.ecs.model.ListTasksResult;
import com.amazonaws.services.ecs.model.MissingVersionException;
import com.amazonaws.services.ecs.model.NoUpdateAvailableException;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceRequest;
import com.amazonaws.services.ecs.model.RegisterContainerInstanceResult;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionRequest;
import com.amazonaws.services.ecs.model.RegisterTaskDefinitionResult;
import com.amazonaws.services.ecs.model.RunTaskRequest;
import com.amazonaws.services.ecs.model.RunTaskResult;
import com.amazonaws.services.ecs.model.ServerException;
import com.amazonaws.services.ecs.model.ServiceNotActiveException;
import com.amazonaws.services.ecs.model.ServiceNotFoundException;
import com.amazonaws.services.ecs.model.StartTaskRequest;
import com.amazonaws.services.ecs.model.StartTaskResult;
import com.amazonaws.services.ecs.model.StopTaskRequest;
import com.amazonaws.services.ecs.model.StopTaskResult;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitContainerStateChangeResult;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeResult;
import com.amazonaws.services.ecs.model.UpdateContainerAgentRequest;
import com.amazonaws.services.ecs.model.UpdateContainerAgentResult;
import com.amazonaws.services.ecs.model.UpdateInProgressException;
import com.amazonaws.services.ecs.model.UpdateServiceRequest;
import com.amazonaws.services.ecs.model.UpdateServiceResult;
import com.amazonaws.services.ecs.model.transform.CreateClusterRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.CreateClusterResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.CreateServiceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.CreateServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteClusterRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteClusterResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteServiceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeleteServiceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterContainerInstanceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterContainerInstanceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterTaskDefinitionRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DeregisterTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeClustersRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeClustersResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeContainerInstancesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeContainerInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeServicesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeServicesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTaskDefinitionRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTasksRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DescribeTasksResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.DiscoverPollEndpointRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.DiscoverPollEndpointResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListClustersRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListContainerInstancesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListContainerInstancesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListServicesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListServicesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionFamiliesRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionFamiliesResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionsRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTaskDefinitionsResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.ListTasksRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.ListTasksResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterContainerInstanceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterContainerInstanceResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterTaskDefinitionRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.RegisterTaskDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.RunTaskRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.RunTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.StartTaskRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.StartTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.StopTaskRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.StopTaskResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitContainerStateChangeRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitContainerStateChangeResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitTaskStateChangeRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.SubmitTaskStateChangeResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerAgentRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateContainerAgentResultJsonUnmarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateServiceRequestMarshaller;
import com.amazonaws.services.ecs.model.transform.UpdateServiceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonECSClient
extends AmazonWebServiceClient
implements AmazonECS {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECS.class);
    private static final String DEFAULT_SIGNING_NAME = "ecs";
    private static final String DEFAULT_ENDPOINT_PREFIX = "ecs";
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonECSClient() {
        this(new DefaultAWSCredentialsProviderChain(), PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonECSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonECSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonECSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig());
    }

    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonECSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ClusterContainsServicesException.class, "ClusterContainsServicesException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ServerException.class, "ServerException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoUpdateAvailableException.class, "NoUpdateAvailableException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ClusterNotFoundException.class, "ClusterNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(UpdateInProgressException.class, "UpdateInProgressException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ServiceNotFoundException.class, "ServiceNotFoundException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ServiceNotActiveException.class, "ServiceNotActiveException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MissingVersionException.class, "MissingVersionException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidParameterException.class, "InvalidParameterException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ClusterContainsContainerInstancesException.class, "ClusterContainsContainerInstancesException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ClientException.class, "ClientException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setEndpoint("https://ecs.us-east-1.amazonaws.com");
        this.setServiceNameIntern("ecs");
        this.setEndpointPrefix("ecs");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecs/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecs/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResult createCluster(CreateClusterRequest createClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateClusterRequestMarshaller().marshall(createClusterRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateClusterResult> responseHandler = new JsonResponseHandler<CreateClusterResult>(new CreateClusterResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateClusterResult createClusterResult = (CreateClusterResult)response.getAwsResponse();
            return createClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateClusterResult createCluster() {
        return this.createCluster(new CreateClusterRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServiceResult createService(CreateServiceRequest createServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServiceRequestMarshaller().marshall(createServiceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<CreateServiceResult> responseHandler = new JsonResponseHandler<CreateServiceResult>(new CreateServiceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            CreateServiceResult createServiceResult = (CreateServiceResult)response.getAwsResponse();
            return createServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResult deleteCluster(DeleteClusterRequest deleteClusterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteClusterRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteClusterRequestMarshaller().marshall(deleteClusterRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteClusterResult> responseHandler = new JsonResponseHandler<DeleteClusterResult>(new DeleteClusterResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteClusterResult deleteClusterResult = (DeleteClusterResult)response.getAwsResponse();
            return deleteClusterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServiceResult deleteService(DeleteServiceRequest deleteServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServiceRequestMarshaller().marshall(deleteServiceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeleteServiceResult> responseHandler = new JsonResponseHandler<DeleteServiceResult>(new DeleteServiceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServiceResult deleteServiceResult = (DeleteServiceResult)response.getAwsResponse();
            return deleteServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterContainerInstanceResult deregisterContainerInstance(DeregisterContainerInstanceRequest deregisterContainerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterContainerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterContainerInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterContainerInstanceRequestMarshaller().marshall(deregisterContainerInstanceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeregisterContainerInstanceResult> responseHandler = new JsonResponseHandler<DeregisterContainerInstanceResult>(new DeregisterContainerInstanceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterContainerInstanceResult deregisterContainerInstanceResult = (DeregisterContainerInstanceResult)response.getAwsResponse();
            return deregisterContainerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterTaskDefinitionResult deregisterTaskDefinition(DeregisterTaskDefinitionRequest deregisterTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deregisterTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeregisterTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeregisterTaskDefinitionRequestMarshaller().marshall(deregisterTaskDefinitionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DeregisterTaskDefinitionResult> responseHandler = new JsonResponseHandler<DeregisterTaskDefinitionResult>(new DeregisterTaskDefinitionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DeregisterTaskDefinitionResult deregisterTaskDefinitionResult = (DeregisterTaskDefinitionResult)response.getAwsResponse();
            return deregisterTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClustersResult describeClusters(DescribeClustersRequest describeClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClustersRequestMarshaller().marshall(describeClustersRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeClustersResult> responseHandler = new JsonResponseHandler<DescribeClustersResult>(new DescribeClustersResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeClustersResult describeClustersResult = (DescribeClustersResult)response.getAwsResponse();
            return describeClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeClustersResult describeClusters() {
        return this.describeClusters(new DescribeClustersRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeContainerInstancesResult describeContainerInstances(DescribeContainerInstancesRequest describeContainerInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeContainerInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeContainerInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeContainerInstancesRequestMarshaller().marshall(describeContainerInstancesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeContainerInstancesResult> responseHandler = new JsonResponseHandler<DescribeContainerInstancesResult>(new DescribeContainerInstancesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeContainerInstancesResult describeContainerInstancesResult = (DescribeContainerInstancesResult)response.getAwsResponse();
            return describeContainerInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServicesResult describeServices(DescribeServicesRequest describeServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServicesRequestMarshaller().marshall(describeServicesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeServicesResult> responseHandler = new JsonResponseHandler<DescribeServicesResult>(new DescribeServicesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServicesResult describeServicesResult = (DescribeServicesResult)response.getAwsResponse();
            return describeServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTaskDefinitionResult describeTaskDefinition(DescribeTaskDefinitionRequest describeTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTaskDefinitionRequestMarshaller().marshall(describeTaskDefinitionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeTaskDefinitionResult> responseHandler = new JsonResponseHandler<DescribeTaskDefinitionResult>(new DescribeTaskDefinitionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTaskDefinitionResult describeTaskDefinitionResult = (DescribeTaskDefinitionResult)response.getAwsResponse();
            return describeTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTasksResult describeTasks(DescribeTasksRequest describeTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTasksRequestMarshaller().marshall(describeTasksRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DescribeTasksResult> responseHandler = new JsonResponseHandler<DescribeTasksResult>(new DescribeTasksResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeTasksResult describeTasksResult = (DescribeTasksResult)response.getAwsResponse();
            return describeTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoverPollEndpointResult discoverPollEndpoint(DiscoverPollEndpointRequest discoverPollEndpointRequest) {
        ExecutionContext executionContext = this.createExecutionContext(discoverPollEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DiscoverPollEndpointRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DiscoverPollEndpointRequestMarshaller().marshall(discoverPollEndpointRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<DiscoverPollEndpointResult> responseHandler = new JsonResponseHandler<DiscoverPollEndpointResult>(new DiscoverPollEndpointResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            DiscoverPollEndpointResult discoverPollEndpointResult = (DiscoverPollEndpointResult)response.getAwsResponse();
            return discoverPollEndpointResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DiscoverPollEndpointResult discoverPollEndpoint() {
        return this.discoverPollEndpoint(new DiscoverPollEndpointRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResult listClusters(ListClustersRequest listClustersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestMarshaller().marshall(listClustersRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListClustersResult> responseHandler = new JsonResponseHandler<ListClustersResult>(new ListClustersResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListClustersResult listClustersResult = (ListClustersResult)response.getAwsResponse();
            return listClustersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListClustersResult listClusters() {
        return this.listClusters(new ListClustersRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListContainerInstancesResult listContainerInstances(ListContainerInstancesRequest listContainerInstancesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listContainerInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListContainerInstancesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListContainerInstancesRequestMarshaller().marshall(listContainerInstancesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListContainerInstancesResult> responseHandler = new JsonResponseHandler<ListContainerInstancesResult>(new ListContainerInstancesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListContainerInstancesResult listContainerInstancesResult = (ListContainerInstancesResult)response.getAwsResponse();
            return listContainerInstancesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListContainerInstancesResult listContainerInstances() {
        return this.listContainerInstances(new ListContainerInstancesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServicesResult listServices(ListServicesRequest listServicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listServicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListServicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListServicesRequestMarshaller().marshall(listServicesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListServicesResult> responseHandler = new JsonResponseHandler<ListServicesResult>(new ListServicesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListServicesResult listServicesResult = (ListServicesResult)response.getAwsResponse();
            return listServicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListServicesResult listServices() {
        return this.listServices(new ListServicesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaskDefinitionFamiliesResult listTaskDefinitionFamilies(ListTaskDefinitionFamiliesRequest listTaskDefinitionFamiliesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskDefinitionFamiliesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskDefinitionFamiliesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskDefinitionFamiliesRequestMarshaller().marshall(listTaskDefinitionFamiliesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListTaskDefinitionFamiliesResult> responseHandler = new JsonResponseHandler<ListTaskDefinitionFamiliesResult>(new ListTaskDefinitionFamiliesResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListTaskDefinitionFamiliesResult listTaskDefinitionFamiliesResult = (ListTaskDefinitionFamiliesResult)response.getAwsResponse();
            return listTaskDefinitionFamiliesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTaskDefinitionFamiliesResult listTaskDefinitionFamilies() {
        return this.listTaskDefinitionFamilies(new ListTaskDefinitionFamiliesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTaskDefinitionsResult listTaskDefinitions(ListTaskDefinitionsRequest listTaskDefinitionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTaskDefinitionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTaskDefinitionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTaskDefinitionsRequestMarshaller().marshall(listTaskDefinitionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListTaskDefinitionsResult> responseHandler = new JsonResponseHandler<ListTaskDefinitionsResult>(new ListTaskDefinitionsResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListTaskDefinitionsResult listTaskDefinitionsResult = (ListTaskDefinitionsResult)response.getAwsResponse();
            return listTaskDefinitionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTaskDefinitionsResult listTaskDefinitions() {
        return this.listTaskDefinitions(new ListTaskDefinitionsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTasksResult listTasks(ListTasksRequest listTasksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTasksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTasksRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTasksRequestMarshaller().marshall(listTasksRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<ListTasksResult> responseHandler = new JsonResponseHandler<ListTasksResult>(new ListTasksResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            ListTasksResult listTasksResult = (ListTasksResult)response.getAwsResponse();
            return listTasksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTasksResult listTasks() {
        return this.listTasks(new ListTasksRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterContainerInstanceResult registerContainerInstance(RegisterContainerInstanceRequest registerContainerInstanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerContainerInstanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterContainerInstanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterContainerInstanceRequestMarshaller().marshall(registerContainerInstanceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<RegisterContainerInstanceResult> responseHandler = new JsonResponseHandler<RegisterContainerInstanceResult>(new RegisterContainerInstanceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            RegisterContainerInstanceResult registerContainerInstanceResult = (RegisterContainerInstanceResult)response.getAwsResponse();
            return registerContainerInstanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterTaskDefinitionResult registerTaskDefinition(RegisterTaskDefinitionRequest registerTaskDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(registerTaskDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RegisterTaskDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RegisterTaskDefinitionRequestMarshaller().marshall(registerTaskDefinitionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<RegisterTaskDefinitionResult> responseHandler = new JsonResponseHandler<RegisterTaskDefinitionResult>(new RegisterTaskDefinitionResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            RegisterTaskDefinitionResult registerTaskDefinitionResult = (RegisterTaskDefinitionResult)response.getAwsResponse();
            return registerTaskDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunTaskResult runTask(RunTaskRequest runTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(runTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunTaskRequestMarshaller().marshall(runTaskRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<RunTaskResult> responseHandler = new JsonResponseHandler<RunTaskResult>(new RunTaskResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            RunTaskResult runTaskResult = (RunTaskResult)response.getAwsResponse();
            return runTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTaskResult startTask(StartTaskRequest startTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartTaskRequestMarshaller().marshall(startTaskRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<StartTaskResult> responseHandler = new JsonResponseHandler<StartTaskResult>(new StartTaskResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            StartTaskResult startTaskResult = (StartTaskResult)response.getAwsResponse();
            return startTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopTaskResult stopTask(StopTaskRequest stopTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopTaskRequestMarshaller().marshall(stopTaskRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<StopTaskResult> responseHandler = new JsonResponseHandler<StopTaskResult>(new StopTaskResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            StopTaskResult stopTaskResult = (StopTaskResult)response.getAwsResponse();
            return stopTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitContainerStateChangeResult submitContainerStateChange(SubmitContainerStateChangeRequest submitContainerStateChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitContainerStateChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitContainerStateChangeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitContainerStateChangeRequestMarshaller().marshall(submitContainerStateChangeRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<SubmitContainerStateChangeResult> responseHandler = new JsonResponseHandler<SubmitContainerStateChangeResult>(new SubmitContainerStateChangeResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            SubmitContainerStateChangeResult submitContainerStateChangeResult = (SubmitContainerStateChangeResult)response.getAwsResponse();
            return submitContainerStateChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public SubmitContainerStateChangeResult submitContainerStateChange() {
        return this.submitContainerStateChange(new SubmitContainerStateChangeRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmitTaskStateChangeResult submitTaskStateChange(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(submitTaskStateChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubmitTaskStateChangeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SubmitTaskStateChangeRequestMarshaller().marshall(submitTaskStateChangeRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<SubmitTaskStateChangeResult> responseHandler = new JsonResponseHandler<SubmitTaskStateChangeResult>(new SubmitTaskStateChangeResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            SubmitTaskStateChangeResult submitTaskStateChangeResult = (SubmitTaskStateChangeResult)response.getAwsResponse();
            return submitTaskStateChangeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateContainerAgentResult updateContainerAgent(UpdateContainerAgentRequest updateContainerAgentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateContainerAgentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateContainerAgentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateContainerAgentRequestMarshaller().marshall(updateContainerAgentRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateContainerAgentResult> responseHandler = new JsonResponseHandler<UpdateContainerAgentResult>(new UpdateContainerAgentResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateContainerAgentResult updateContainerAgentResult = (UpdateContainerAgentResult)response.getAwsResponse();
            return updateContainerAgentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceResult updateService(UpdateServiceRequest updateServiceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServiceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServiceRequestMarshaller().marshall(updateServiceRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler<UpdateServiceResult> responseHandler = new JsonResponseHandler<UpdateServiceResult>(new UpdateServiceResultJsonUnmarshaller());
            responseHandler.setIsPayloadJson(true);
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServiceResult updateServiceResult = (UpdateServiceResult)response.getAwsResponse();
            return updateServiceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandlerV2 errorResponseHandler = new JsonErrorResponseHandlerV2(this.jsonErrorUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

