/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeValueJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class PutRequestJsonMarshaller {
    private static PutRequestJsonMarshaller instance;

    public void marshall(PutRequest putRequest, JSONWriter jsonWriter) {
        if (putRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            Map<String, AttributeValue> itemMap = putRequest.getItem();
            if (itemMap != null) {
                jsonWriter.key("Item");
                jsonWriter.object();
                for (Map.Entry<String, AttributeValue> itemMapValue : itemMap.entrySet()) {
                    if (itemMapValue.getValue() == null) continue;
                    jsonWriter.key(itemMapValue.getKey());
                    AttributeValueJsonMarshaller.getInstance().marshall(itemMapValue.getValue(), jsonWriter);
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PutRequestJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PutRequestJsonMarshaller();
        }
        return instance;
    }
}

