/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeLifecycleHooksRequestMarshaller
implements Marshaller<Request<DescribeLifecycleHooksRequest>, DescribeLifecycleHooksRequest> {
    @Override
    public Request<DescribeLifecycleHooksRequest> marshall(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        SdkInternalList lifecycleHookNamesList;
        if (describeLifecycleHooksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLifecycleHooksRequest> request = new DefaultRequest<DescribeLifecycleHooksRequest>(describeLifecycleHooksRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DescribeLifecycleHooks");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLifecycleHooksRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(describeLifecycleHooksRequest.getAutoScalingGroupName()));
        }
        if (!(lifecycleHookNamesList = (SdkInternalList)describeLifecycleHooksRequest.getLifecycleHookNames()).isEmpty() || !lifecycleHookNamesList.isAutoConstruct()) {
            int lifecycleHookNamesListIndex = 1;
            for (String lifecycleHookNamesListValue : lifecycleHookNamesList) {
                if (lifecycleHookNamesListValue != null) {
                    request.addParameter("LifecycleHookNames.member." + lifecycleHookNamesListIndex, StringUtils.fromString(lifecycleHookNamesListValue));
                }
                ++lifecycleHookNamesListIndex;
            }
        }
        return request;
    }
}

