/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Deployment;
import com.amazonaws.services.apigateway.model.MethodSnapshot;
import com.amazonaws.services.apigateway.model.transform.MethodSnapshotJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class DeploymentJsonMarshaller {
    private static DeploymentJsonMarshaller instance;

    public void marshall(Deployment deployment, JSONWriter jsonWriter) {
        if (deployment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, Map<String, MethodSnapshot>> apiSummaryMap;
            jsonWriter.object();
            if (deployment.getId() != null) {
                jsonWriter.key("id").value(deployment.getId());
            }
            if (deployment.getDescription() != null) {
                jsonWriter.key("description").value(deployment.getDescription());
            }
            if (deployment.getCreatedDate() != null) {
                jsonWriter.key("createdDate").value(deployment.getCreatedDate());
            }
            if ((apiSummaryMap = deployment.getApiSummary()) != null) {
                jsonWriter.key("apiSummary");
                jsonWriter.object();
                for (Map.Entry<String, Map<String, MethodSnapshot>> apiSummaryMapValue : apiSummaryMap.entrySet()) {
                    if (apiSummaryMapValue.getValue() == null) continue;
                    jsonWriter.key(apiSummaryMapValue.getKey());
                    jsonWriter.object();
                    for (Map.Entry<String, MethodSnapshot> apiSummaryMapValueNestedMap : apiSummaryMapValue.getValue().entrySet()) {
                        if (apiSummaryMapValueNestedMap.getValue() == null) continue;
                        jsonWriter.key(apiSummaryMapValueNestedMap.getKey());
                        MethodSnapshotJsonMarshaller.getInstance().marshall(apiSummaryMapValueNestedMap.getValue(), jsonWriter);
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentJsonMarshaller();
        }
        return instance;
    }
}

