/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.GetGeoLocationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class GetGeoLocationRequestMarshaller
implements Marshaller<Request<GetGeoLocationRequest>, GetGeoLocationRequest> {
    private static final String RESOURCE_PATH_TEMPLATE;
    private static final Map<String, String> STATIC_QUERY_PARAMS;
    private static final Map<String, String> DYNAMIC_QUERY_PARAMS;

    @Override
    public Request<GetGeoLocationRequest> marshall(GetGeoLocationRequest getGeoLocationRequest) {
        String value;
        String name;
        if (getGeoLocationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetGeoLocationRequest> request = new DefaultRequest<GetGeoLocationRequest>(getGeoLocationRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = RESOURCE_PATH_TEMPLATE;
        if (DYNAMIC_QUERY_PARAMS.containsKey("ContinentCode")) {
            name = DYNAMIC_QUERY_PARAMS.get("ContinentCode");
            String string = value = getGeoLocationRequest.getContinentCode() == null ? null : StringUtils.fromString(getGeoLocationRequest.getContinentCode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{ContinentCode}", getGeoLocationRequest.getContinentCode() == null ? "" : StringUtils.fromString(getGeoLocationRequest.getContinentCode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("CountryCode")) {
            name = DYNAMIC_QUERY_PARAMS.get("CountryCode");
            String string = value = getGeoLocationRequest.getCountryCode() == null ? null : StringUtils.fromString(getGeoLocationRequest.getCountryCode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{CountryCode}", getGeoLocationRequest.getCountryCode() == null ? "" : StringUtils.fromString(getGeoLocationRequest.getCountryCode()));
        }
        if (DYNAMIC_QUERY_PARAMS.containsKey("SubdivisionCode")) {
            name = DYNAMIC_QUERY_PARAMS.get("SubdivisionCode");
            String string = value = getGeoLocationRequest.getSubdivisionCode() == null ? null : StringUtils.fromString(getGeoLocationRequest.getSubdivisionCode());
            if (value != null && !value.isEmpty()) {
                request.addParameter(name, value);
            }
        } else {
            uriResourcePath = uriResourcePath.replace("{SubdivisionCode}", getGeoLocationRequest.getSubdivisionCode() == null ? "" : StringUtils.fromString(getGeoLocationRequest.getSubdivisionCode()));
        }
        request.setResourcePath(uriResourcePath.replaceAll("//", "/"));
        for (Map.Entry<String, String> entry : STATIC_QUERY_PARAMS.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        return request;
    }

    static {
        String path = "/2013-04-01/geolocation?continentcode={ContinentCode}&countrycode={CountryCode}&subdivisioncode={SubdivisionCode}";
        HashMap<String, String> staticMap = new HashMap<String, String>();
        HashMap<String, String> dynamicMap = new HashMap<String, String>();
        int index = path.indexOf("?");
        if (index != -1) {
            String queryString = path.substring(index + 1);
            path = path.substring(0, index);
            for (String s : queryString.split("[;&]")) {
                index = s.indexOf("=");
                if (index == -1) continue;
                String name = s.substring(0, index);
                String value = s.substring(index + 1);
                if (value.startsWith("{") && value.endsWith("}")) {
                    dynamicMap.put(value.substring(1, value.length() - 1), name);
                    continue;
                }
                staticMap.put(name, value);
            }
        }
        RESOURCE_PATH_TEMPLATE = path;
        STATIC_QUERY_PARAMS = Collections.unmodifiableMap(staticMap);
        DYNAMIC_QUERY_PARAMS = Collections.unmodifiableMap(dynamicMap);
    }
}

