/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.inspector.model.ListRunsRequest;
import com.amazonaws.services.inspector.model.transform.RunsFilterJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;

public class ListRunsRequestMarshaller
implements Marshaller<Request<ListRunsRequest>, ListRunsRequest> {
    @Override
    public Request<ListRunsRequest> marshall(ListRunsRequest listRunsRequest) {
        if (listRunsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListRunsRequest> request = new DefaultRequest<ListRunsRequest>(listRunsRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.ListRuns");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            List<String> assessmentArnsList = listRunsRequest.getAssessmentArns();
            if (assessmentArnsList != null) {
                jsonWriter.key("assessmentArns");
                jsonWriter.array();
                for (String assessmentArnsListValue : assessmentArnsList) {
                    if (assessmentArnsListValue == null) continue;
                    jsonWriter.value(assessmentArnsListValue);
                }
                jsonWriter.endArray();
            }
            if (listRunsRequest.getFilter() != null) {
                jsonWriter.key("filter");
                RunsFilterJsonMarshaller.getInstance().marshall(listRunsRequest.getFilter(), jsonWriter);
            }
            if (listRunsRequest.getNextToken() != null) {
                jsonWriter.key("nextToken").value(listRunsRequest.getNextToken());
            }
            if (listRunsRequest.getMaxResults() != null) {
                jsonWriter.key("maxResults").value(listRunsRequest.getMaxResults());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

