/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.DirectoryDescription;
import com.amazonaws.services.directory.model.transform.DirectoryConnectSettingsDescriptionJsonMarshaller;
import com.amazonaws.services.directory.model.transform.DirectoryVpcSettingsDescriptionJsonMarshaller;
import com.amazonaws.services.directory.model.transform.RadiusSettingsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DirectoryDescriptionJsonMarshaller {
    private static DirectoryDescriptionJsonMarshaller instance;

    public void marshall(DirectoryDescription directoryDescription, JSONWriter jsonWriter) {
        if (directoryDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dnsIpAddrsList;
            jsonWriter.object();
            if (directoryDescription.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value(directoryDescription.getDirectoryId());
            }
            if (directoryDescription.getName() != null) {
                jsonWriter.key("Name").value(directoryDescription.getName());
            }
            if (directoryDescription.getShortName() != null) {
                jsonWriter.key("ShortName").value(directoryDescription.getShortName());
            }
            if (directoryDescription.getSize() != null) {
                jsonWriter.key("Size").value(directoryDescription.getSize());
            }
            if (directoryDescription.getAlias() != null) {
                jsonWriter.key("Alias").value(directoryDescription.getAlias());
            }
            if (directoryDescription.getAccessUrl() != null) {
                jsonWriter.key("AccessUrl").value(directoryDescription.getAccessUrl());
            }
            if (directoryDescription.getDescription() != null) {
                jsonWriter.key("Description").value(directoryDescription.getDescription());
            }
            if (!(dnsIpAddrsList = (SdkInternalList)directoryDescription.getDnsIpAddrs()).isEmpty() || !dnsIpAddrsList.isAutoConstruct()) {
                jsonWriter.key("DnsIpAddrs");
                jsonWriter.array();
                for (String dnsIpAddrsListValue : dnsIpAddrsList) {
                    if (dnsIpAddrsListValue == null) continue;
                    jsonWriter.value(dnsIpAddrsListValue);
                }
                jsonWriter.endArray();
            }
            if (directoryDescription.getStage() != null) {
                jsonWriter.key("Stage").value(directoryDescription.getStage());
            }
            if (directoryDescription.getLaunchTime() != null) {
                jsonWriter.key("LaunchTime").value(directoryDescription.getLaunchTime());
            }
            if (directoryDescription.getStageLastUpdatedDateTime() != null) {
                jsonWriter.key("StageLastUpdatedDateTime").value(directoryDescription.getStageLastUpdatedDateTime());
            }
            if (directoryDescription.getType() != null) {
                jsonWriter.key("Type").value(directoryDescription.getType());
            }
            if (directoryDescription.getVpcSettings() != null) {
                jsonWriter.key("VpcSettings");
                DirectoryVpcSettingsDescriptionJsonMarshaller.getInstance().marshall(directoryDescription.getVpcSettings(), jsonWriter);
            }
            if (directoryDescription.getConnectSettings() != null) {
                jsonWriter.key("ConnectSettings");
                DirectoryConnectSettingsDescriptionJsonMarshaller.getInstance().marshall(directoryDescription.getConnectSettings(), jsonWriter);
            }
            if (directoryDescription.getRadiusSettings() != null) {
                jsonWriter.key("RadiusSettings");
                RadiusSettingsJsonMarshaller.getInstance().marshall(directoryDescription.getRadiusSettings(), jsonWriter);
            }
            if (directoryDescription.getRadiusStatus() != null) {
                jsonWriter.key("RadiusStatus").value(directoryDescription.getRadiusStatus());
            }
            if (directoryDescription.getStageReason() != null) {
                jsonWriter.key("StageReason").value(directoryDescription.getStageReason());
            }
            if (directoryDescription.getSsoEnabled() != null) {
                jsonWriter.key("SsoEnabled").value(directoryDescription.getSsoEnabled());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DirectoryDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DirectoryDescriptionJsonMarshaller();
        }
        return instance;
    }
}

