/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.iotdata.model.UpdateThingShadowRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;

public class UpdateThingShadowRequestMarshaller
implements Marshaller<Request<UpdateThingShadowRequest>, UpdateThingShadowRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<UpdateThingShadowRequest> marshall(UpdateThingShadowRequest updateThingShadowRequest) {
        if (updateThingShadowRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateThingShadowRequest> request = new DefaultRequest<UpdateThingShadowRequest>(updateThingShadowRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/things/{thingName}/shadow";
        uriResourcePath = uriResourcePath.replace("{thingName}", updateThingShadowRequest.getThingName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(updateThingShadowRequest.getThingName()));
        request.setResourcePath(uriResourcePath);
        request.setContent(BinaryUtils.toStream(updateThingShadowRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

