/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.inspector.model.RunsFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListRunsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> assessmentArns;
    private RunsFilter filter;
    private String nextToken;
    private Integer maxResults;

    public List<String> getAssessmentArns() {
        return this.assessmentArns;
    }

    public void setAssessmentArns(Collection<String> assessmentArns) {
        if (assessmentArns == null) {
            this.assessmentArns = null;
            return;
        }
        this.assessmentArns = new ArrayList<String>(assessmentArns);
    }

    public ListRunsRequest withAssessmentArns(String ... assessmentArns) {
        if (this.assessmentArns == null) {
            this.setAssessmentArns(new ArrayList<String>(assessmentArns.length));
        }
        for (String ele : assessmentArns) {
            this.assessmentArns.add(ele);
        }
        return this;
    }

    public ListRunsRequest withAssessmentArns(Collection<String> assessmentArns) {
        this.setAssessmentArns(assessmentArns);
        return this;
    }

    public void setFilter(RunsFilter filter) {
        this.filter = filter;
    }

    public RunsFilter getFilter() {
        return this.filter;
    }

    public ListRunsRequest withFilter(RunsFilter filter) {
        this.setFilter(filter);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListRunsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListRunsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssessmentArns() != null) {
            sb.append("AssessmentArns: " + this.getAssessmentArns() + ",");
        }
        if (this.getFilter() != null) {
            sb.append("Filter: " + this.getFilter() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken() + ",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: " + this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsRequest)) {
            return false;
        }
        ListRunsRequest other = (ListRunsRequest)obj;
        if (other.getAssessmentArns() == null ^ this.getAssessmentArns() == null) {
            return false;
        }
        if (other.getAssessmentArns() != null && !other.getAssessmentArns().equals(this.getAssessmentArns())) {
            return false;
        }
        if (other.getFilter() == null ^ this.getFilter() == null) {
            return false;
        }
        if (other.getFilter() != null && !other.getFilter().equals(this.getFilter())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssessmentArns() == null ? 0 : this.getAssessmentArns().hashCode());
        hashCode = 31 * hashCode + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    @Override
    public ListRunsRequest clone() {
        return (ListRunsRequest)super.clone();
    }
}

