/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.services.identitymanagement.model.EvaluationResult;
import com.amazonaws.services.identitymanagement.model.transform.StatementStaxUnmarshaller;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

public class EvaluationResultStaxUnmarshaller
implements Unmarshaller<EvaluationResult, StaxUnmarshallerContext> {
    private static EvaluationResultStaxUnmarshaller instance;

    @Override
    public EvaluationResult unmarshall(StaxUnmarshallerContext context) throws Exception {
        EvaluationResult evaluationResult = new EvaluationResult();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return evaluationResult;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EvalActionName", targetDepth)) {
                    evaluationResult.setEvalActionName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EvalResourceName", targetDepth)) {
                    evaluationResult.setEvalResourceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EvalDecision", targetDepth)) {
                    evaluationResult.setEvalDecision(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MatchedStatements/member", targetDepth)) {
                    evaluationResult.getMatchedStatements().add(StatementStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MissingContextValues/member", targetDepth)) {
                    evaluationResult.getMissingContextValues().add(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EvalDecisionDetails/entry", targetDepth)) continue;
                Map.Entry<String, String> entry = EvalDecisionDetailsMapEntryUnmarshaller.getInstance().unmarshall(context);
                evaluationResult.getEvalDecisionDetails().put(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return evaluationResult;
    }

    public static EvaluationResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EvaluationResultStaxUnmarshaller();
        }
        return instance;
    }

    private static class EvalDecisionDetailsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static EvalDecisionDetailsMapEntryUnmarshaller instance;

        private EvalDecisionDetailsMapEntryUnmarshaller() {
        }

        @Override
        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry<String, String> entry = new MapEntry<String, String>();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static EvalDecisionDetailsMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new EvalDecisionDetailsMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

