/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateFlowLogsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateFlowLogsRequestMarshaller
implements Marshaller<Request<CreateFlowLogsRequest>, CreateFlowLogsRequest> {
    @Override
    public Request<CreateFlowLogsRequest> marshall(CreateFlowLogsRequest createFlowLogsRequest) {
        if (createFlowLogsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFlowLogsRequest> request = new DefaultRequest<CreateFlowLogsRequest>(createFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateFlowLogs");
        request.addParameter("Version", "2015-10-01");
        List<String> resourceIdsList = createFlowLogsRequest.getResourceIds();
        int resourceIdsListIndex = 1;
        for (String resourceIdsListValue : resourceIdsList) {
            if (resourceIdsListValue != null) {
                request.addParameter("ResourceId." + resourceIdsListIndex, StringUtils.fromString(resourceIdsListValue));
            }
            ++resourceIdsListIndex;
        }
        if (createFlowLogsRequest.getResourceType() != null) {
            request.addParameter("ResourceType", StringUtils.fromString(createFlowLogsRequest.getResourceType()));
        }
        if (createFlowLogsRequest.getTrafficType() != null) {
            request.addParameter("TrafficType", StringUtils.fromString(createFlowLogsRequest.getTrafficType()));
        }
        if (createFlowLogsRequest.getLogGroupName() != null) {
            request.addParameter("LogGroupName", StringUtils.fromString(createFlowLogsRequest.getLogGroupName()));
        }
        if (createFlowLogsRequest.getDeliverLogsPermissionArn() != null) {
            request.addParameter("DeliverLogsPermissionArn", StringUtils.fromString(createFlowLogsRequest.getDeliverLogsPermissionArn()));
        }
        if (createFlowLogsRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createFlowLogsRequest.getClientToken()));
        }
        return request;
    }
}

