/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.CreateBasePathMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class CreateBasePathMappingRequestMarshaller
implements Marshaller<Request<CreateBasePathMappingRequest>, CreateBasePathMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<CreateBasePathMappingRequest> marshall(CreateBasePathMappingRequest createBasePathMappingRequest) {
        if (createBasePathMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateBasePathMappingRequest> request = new DefaultRequest<CreateBasePathMappingRequest>(createBasePathMappingRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings";
        uriResourcePath = uriResourcePath.replace("{domain_name}", createBasePathMappingRequest.getDomainName() == null ? DEFAULT_CONTENT_TYPE : StringUtils.fromString(createBasePathMappingRequest.getDomainName()));
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createBasePathMappingRequest.getBasePath() != null) {
                jsonWriter.key("basePath").value(createBasePathMappingRequest.getBasePath());
            }
            if (createBasePathMappingRequest.getRestApiId() != null) {
                jsonWriter.key("restApiId").value(createBasePathMappingRequest.getRestApiId());
            }
            if (createBasePathMappingRequest.getStage() != null) {
                jsonWriter.key("stage").value(createBasePathMappingRequest.getStage());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

