/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.organizations.model.ActionType;
import com.amazonaws.services.organizations.model.HandshakeParty;
import com.amazonaws.services.organizations.model.HandshakeResource;
import com.amazonaws.services.organizations.model.HandshakeState;
import com.amazonaws.services.organizations.model.transform.HandshakeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Handshake
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String arn;
    private List<HandshakeParty> parties;
    private String state;
    private Date requestedTimestamp;
    private Date expirationTimestamp;
    private String action;
    private List<HandshakeResource> resources;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Handshake withId(String id) {
        this.setId(id);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Handshake withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public List<HandshakeParty> getParties() {
        return this.parties;
    }

    public void setParties(Collection<HandshakeParty> parties) {
        if (parties == null) {
            this.parties = null;
            return;
        }
        this.parties = new ArrayList<HandshakeParty>(parties);
    }

    public Handshake withParties(HandshakeParty ... parties) {
        if (this.parties == null) {
            this.setParties(new ArrayList<HandshakeParty>(parties.length));
        }
        for (HandshakeParty ele : parties) {
            this.parties.add(ele);
        }
        return this;
    }

    public Handshake withParties(Collection<HandshakeParty> parties) {
        this.setParties(parties);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Handshake withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(HandshakeState state) {
        this.state = state.toString();
    }

    public Handshake withState(HandshakeState state) {
        this.setState(state);
        return this;
    }

    public void setRequestedTimestamp(Date requestedTimestamp) {
        this.requestedTimestamp = requestedTimestamp;
    }

    public Date getRequestedTimestamp() {
        return this.requestedTimestamp;
    }

    public Handshake withRequestedTimestamp(Date requestedTimestamp) {
        this.setRequestedTimestamp(requestedTimestamp);
        return this;
    }

    public void setExpirationTimestamp(Date expirationTimestamp) {
        this.expirationTimestamp = expirationTimestamp;
    }

    public Date getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public Handshake withExpirationTimestamp(Date expirationTimestamp) {
        this.setExpirationTimestamp(expirationTimestamp);
        return this;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public Handshake withAction(String action) {
        this.setAction(action);
        return this;
    }

    public void setAction(ActionType action) {
        this.action = action.toString();
    }

    public Handshake withAction(ActionType action) {
        this.setAction(action);
        return this;
    }

    public List<HandshakeResource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<HandshakeResource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<HandshakeResource>(resources);
    }

    public Handshake withResources(HandshakeResource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<HandshakeResource>(resources.length));
        }
        for (HandshakeResource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public Handshake withResources(Collection<HandshakeResource> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getParties() != null) {
            sb.append("Parties: ").append(this.getParties()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getRequestedTimestamp() != null) {
            sb.append("RequestedTimestamp: ").append(this.getRequestedTimestamp()).append(",");
        }
        if (this.getExpirationTimestamp() != null) {
            sb.append("ExpirationTimestamp: ").append(this.getExpirationTimestamp()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Handshake)) {
            return false;
        }
        Handshake other = (Handshake)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getParties() == null ^ this.getParties() == null) {
            return false;
        }
        if (other.getParties() != null && !other.getParties().equals(this.getParties())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getRequestedTimestamp() == null ^ this.getRequestedTimestamp() == null) {
            return false;
        }
        if (other.getRequestedTimestamp() != null && !other.getRequestedTimestamp().equals(this.getRequestedTimestamp())) {
            return false;
        }
        if (other.getExpirationTimestamp() == null ^ this.getExpirationTimestamp() == null) {
            return false;
        }
        if (other.getExpirationTimestamp() != null && !other.getExpirationTimestamp().equals(this.getExpirationTimestamp())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getParties() == null ? 0 : this.getParties().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getRequestedTimestamp() == null ? 0 : this.getRequestedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getExpirationTimestamp() == null ? 0 : this.getExpirationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public Handshake clone() {
        try {
            return (Handshake)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HandshakeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

