/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.organizations.model.Child;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListChildrenResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Child> children;
    private String nextToken;

    public List<Child> getChildren() {
        return this.children;
    }

    public void setChildren(Collection<Child> children) {
        if (children == null) {
            this.children = null;
            return;
        }
        this.children = new ArrayList<Child>(children);
    }

    public ListChildrenResult withChildren(Child ... children) {
        if (this.children == null) {
            this.setChildren(new ArrayList<Child>(children.length));
        }
        for (Child ele : children) {
            this.children.add(ele);
        }
        return this;
    }

    public ListChildrenResult withChildren(Collection<Child> children) {
        this.setChildren(children);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListChildrenResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChildren() != null) {
            sb.append("Children: ").append(this.getChildren()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChildrenResult)) {
            return false;
        }
        ListChildrenResult other = (ListChildrenResult)obj;
        if (other.getChildren() == null ^ this.getChildren() == null) {
            return false;
        }
        if (other.getChildren() != null && !other.getChildren().equals(this.getChildren())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChildren() == null ? 0 : this.getChildren().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListChildrenResult clone() {
        try {
            return (ListChildrenResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

