/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworkscm.model.EngineAttribute;
import com.amazonaws.services.opsworkscm.model.Server;
import com.amazonaws.services.opsworkscm.model.transform.EngineAttributeJsonMarshaller;
import java.util.List;

public class ServerJsonMarshaller {
    private static ServerJsonMarshaller instance;

    public void marshall(Server server, StructuredJsonGenerator jsonGenerator) {
        if (server == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<String> securityGroupIdsList;
            List<EngineAttribute> engineAttributesList;
            jsonGenerator.writeStartObject();
            if (server.getBackupRetentionCount() != null) {
                jsonGenerator.writeFieldName("BackupRetentionCount").writeValue(server.getBackupRetentionCount().intValue());
            }
            if (server.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(server.getServerName());
            }
            if (server.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(server.getCreatedAt());
            }
            if (server.getDisableAutomatedBackup() != null) {
                jsonGenerator.writeFieldName("DisableAutomatedBackup").writeValue(server.getDisableAutomatedBackup().booleanValue());
            }
            if (server.getEndpoint() != null) {
                jsonGenerator.writeFieldName("Endpoint").writeValue(server.getEndpoint());
            }
            if (server.getEngine() != null) {
                jsonGenerator.writeFieldName("Engine").writeValue(server.getEngine());
            }
            if (server.getEngineModel() != null) {
                jsonGenerator.writeFieldName("EngineModel").writeValue(server.getEngineModel());
            }
            if ((engineAttributesList = server.getEngineAttributes()) != null) {
                jsonGenerator.writeFieldName("EngineAttributes");
                jsonGenerator.writeStartArray();
                for (EngineAttribute engineAttribute : engineAttributesList) {
                    if (engineAttribute == null) continue;
                    EngineAttributeJsonMarshaller.getInstance().marshall(engineAttribute, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (server.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(server.getEngineVersion());
            }
            if (server.getInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("InstanceProfileArn").writeValue(server.getInstanceProfileArn());
            }
            if (server.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(server.getInstanceType());
            }
            if (server.getKeyPair() != null) {
                jsonGenerator.writeFieldName("KeyPair").writeValue(server.getKeyPair());
            }
            if (server.getMaintenanceStatus() != null) {
                jsonGenerator.writeFieldName("MaintenanceStatus").writeValue(server.getMaintenanceStatus());
            }
            if (server.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(server.getPreferredMaintenanceWindow());
            }
            if (server.getPreferredBackupWindow() != null) {
                jsonGenerator.writeFieldName("PreferredBackupWindow").writeValue(server.getPreferredBackupWindow());
            }
            if ((securityGroupIdsList = server.getSecurityGroupIds()) != null) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (server.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(server.getServiceRoleArn());
            }
            if (server.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(server.getStatus());
            }
            if (server.getStatusReason() != null) {
                jsonGenerator.writeFieldName("StatusReason").writeValue(server.getStatusReason());
            }
            if ((list = server.getSubnetIds()) != null) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : list) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (server.getServerArn() != null) {
                jsonGenerator.writeFieldName("ServerArn").writeValue(server.getServerArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ServerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ServerJsonMarshaller();
        }
        return instance;
    }
}

