/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.opsworkscm.AWSOpsWorksCM;
import com.amazonaws.services.opsworkscm.model.AWSOpsWorksCMException;
import com.amazonaws.services.opsworkscm.model.AssociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.AssociateNodeResult;
import com.amazonaws.services.opsworkscm.model.CreateBackupRequest;
import com.amazonaws.services.opsworkscm.model.CreateBackupResult;
import com.amazonaws.services.opsworkscm.model.CreateServerRequest;
import com.amazonaws.services.opsworkscm.model.CreateServerResult;
import com.amazonaws.services.opsworkscm.model.DeleteBackupRequest;
import com.amazonaws.services.opsworkscm.model.DeleteBackupResult;
import com.amazonaws.services.opsworkscm.model.DeleteServerRequest;
import com.amazonaws.services.opsworkscm.model.DeleteServerResult;
import com.amazonaws.services.opsworkscm.model.DescribeAccountAttributesRequest;
import com.amazonaws.services.opsworkscm.model.DescribeAccountAttributesResult;
import com.amazonaws.services.opsworkscm.model.DescribeBackupsRequest;
import com.amazonaws.services.opsworkscm.model.DescribeBackupsResult;
import com.amazonaws.services.opsworkscm.model.DescribeEventsRequest;
import com.amazonaws.services.opsworkscm.model.DescribeEventsResult;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusRequest;
import com.amazonaws.services.opsworkscm.model.DescribeNodeAssociationStatusResult;
import com.amazonaws.services.opsworkscm.model.DescribeServersRequest;
import com.amazonaws.services.opsworkscm.model.DescribeServersResult;
import com.amazonaws.services.opsworkscm.model.DisassociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.DisassociateNodeResult;
import com.amazonaws.services.opsworkscm.model.InvalidNextTokenException;
import com.amazonaws.services.opsworkscm.model.InvalidStateException;
import com.amazonaws.services.opsworkscm.model.LimitExceededException;
import com.amazonaws.services.opsworkscm.model.ResourceAlreadyExistsException;
import com.amazonaws.services.opsworkscm.model.ResourceNotFoundException;
import com.amazonaws.services.opsworkscm.model.RestoreServerRequest;
import com.amazonaws.services.opsworkscm.model.RestoreServerResult;
import com.amazonaws.services.opsworkscm.model.StartMaintenanceRequest;
import com.amazonaws.services.opsworkscm.model.StartMaintenanceResult;
import com.amazonaws.services.opsworkscm.model.UpdateServerEngineAttributesRequest;
import com.amazonaws.services.opsworkscm.model.UpdateServerEngineAttributesResult;
import com.amazonaws.services.opsworkscm.model.UpdateServerRequest;
import com.amazonaws.services.opsworkscm.model.UpdateServerResult;
import com.amazonaws.services.opsworkscm.model.ValidationException;
import com.amazonaws.services.opsworkscm.model.transform.AssociateNodeRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.AssociateNodeResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateBackupRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateBackupResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateServerRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.CreateServerResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteBackupRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteBackupResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteServerRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DeleteServerResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeAccountAttributesRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeAccountAttributesResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeBackupsRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeBackupsResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeEventsResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeNodeAssociationStatusRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeNodeAssociationStatusResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeServersRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DescribeServersResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DisassociateNodeRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.DisassociateNodeResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.RestoreServerRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.RestoreServerResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.StartMaintenanceRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.StartMaintenanceResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerEngineAttributesRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerEngineAttributesResultJsonUnmarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerRequestMarshaller;
import com.amazonaws.services.opsworkscm.model.transform.UpdateServerResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSOpsWorksCMClient
extends AmazonWebServiceClient
implements AWSOpsWorksCM {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSOpsWorksCM.class);
    private static final String DEFAULT_SIGNING_NAME = "opsworks-cm";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withModeledClass(ValidationException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withModeledClass(ResourceNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withModeledClass(ResourceAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateException").withModeledClass(InvalidStateException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidNextTokenException").withModeledClass(InvalidNextTokenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).withBaseServiceExceptionClass(AWSOpsWorksCMException.class));

    public AWSOpsWorksCMClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), configFactory.getConfig());
    }

    public AWSOpsWorksCMClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration);
    }

    public AWSOpsWorksCMClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSOpsWorksCMClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSOpsWorksCMClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSOpsWorksCMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSOpsWorksCMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AWSOpsWorksCMClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("opsworks-cm.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/opsworkscm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/opsworkscm/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateNodeResult associateNode(AssociateNodeRequest associateNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(associateNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AssociateNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AssociateNodeRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((AssociateNodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)associateNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AssociateNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AssociateNodeResult associateNodeResult = (AssociateNodeResult)response.getAwsResponse();
            return associateNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateBackupResult createBackup(CreateBackupRequest createBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateBackupRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)createBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateBackupResult createBackupResult = (CreateBackupResult)response.getAwsResponse();
            return createBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateServerResult createServer(CreateServerRequest createServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateServerRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((CreateServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)createServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateServerResult createServerResult = (CreateServerResult)response.getAwsResponse();
            return createServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteBackupResult deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteBackupRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteBackupRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteBackupRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteBackupRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteBackupRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteBackupResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteBackupResult deleteBackupResult = (DeleteBackupResult)response.getAwsResponse();
            return deleteBackupResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteServerResult deleteServer(DeleteServerRequest deleteServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteServerRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DeleteServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteServerResult deleteServerResult = (DeleteServerResult)response.getAwsResponse();
            return deleteServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountAttributesResult describeAccountAttributes(DescribeAccountAttributesRequest describeAccountAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAccountAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAccountAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAccountAttributesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeAccountAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAccountAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAccountAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAccountAttributesResult describeAccountAttributesResult = (DescribeAccountAttributesResult)response.getAwsResponse();
            return describeAccountAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeBackupsResult describeBackups(DescribeBackupsRequest describeBackupsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeBackupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeBackupsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeBackupsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeBackupsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeBackupsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeBackupsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeBackupsResult describeBackupsResult = (DescribeBackupsResult)response.getAwsResponse();
            return describeBackupsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventsRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventsResult describeEventsResult = (DescribeEventsResult)response.getAwsResponse();
            return describeEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodeAssociationStatusResult describeNodeAssociationStatus(DescribeNodeAssociationStatusRequest describeNodeAssociationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeNodeAssociationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeNodeAssociationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeNodeAssociationStatusRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeNodeAssociationStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeNodeAssociationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeNodeAssociationStatusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeNodeAssociationStatusResult describeNodeAssociationStatusResult = (DescribeNodeAssociationStatusResult)response.getAwsResponse();
            return describeNodeAssociationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServersResult describeServers(DescribeServersRequest describeServersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeServersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeServersRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DescribeServersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeServersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeServersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeServersResult describeServersResult = (DescribeServersResult)response.getAwsResponse();
            return describeServersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateNodeResult disassociateNode(DisassociateNodeRequest disassociateNodeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateNodeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateNodeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateNodeRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((DisassociateNodeRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateNodeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateNodeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateNodeResult disassociateNodeResult = (DisassociateNodeResult)response.getAwsResponse();
            return disassociateNodeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreServerResult restoreServer(RestoreServerRequest restoreServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restoreServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RestoreServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RestoreServerRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((RestoreServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)restoreServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RestoreServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RestoreServerResult restoreServerResult = (RestoreServerResult)response.getAwsResponse();
            return restoreServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMaintenanceResult startMaintenance(StartMaintenanceRequest startMaintenanceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMaintenanceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMaintenanceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMaintenanceRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((StartMaintenanceRequest)super.beforeMarshalling((AmazonWebServiceRequest)startMaintenanceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMaintenanceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMaintenanceResult startMaintenanceResult = (StartMaintenanceResult)response.getAwsResponse();
            return startMaintenanceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServerResult updateServer(UpdateServerRequest updateServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServerRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateServerRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServerResult updateServerResult = (UpdateServerResult)response.getAwsResponse();
            return updateServerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServerEngineAttributesResult updateServerEngineAttributes(UpdateServerEngineAttributesRequest updateServerEngineAttributesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServerEngineAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateServerEngineAttributesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateServerEngineAttributesRequestMarshaller((SdkJsonMarshallerFactory)this.protocolFactory).marshall((UpdateServerEngineAttributesRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateServerEngineAttributesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateServerEngineAttributesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateServerEngineAttributesResult updateServerEngineAttributesResult = (UpdateServerEngineAttributesResult)response.getAwsResponse();
            return updateServerEngineAttributesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

