/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworkscm.model.Backup;
import java.util.List;

public class BackupJsonMarshaller {
    private static BackupJsonMarshaller instance;

    public void marshall(Backup backup, StructuredJsonGenerator jsonGenerator) {
        if (backup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> subnetIdsList;
            List<String> securityGroupIdsList;
            jsonGenerator.writeStartObject();
            if (backup.getBackupArn() != null) {
                jsonGenerator.writeFieldName("BackupArn").writeValue(backup.getBackupArn());
            }
            if (backup.getBackupId() != null) {
                jsonGenerator.writeFieldName("BackupId").writeValue(backup.getBackupId());
            }
            if (backup.getBackupType() != null) {
                jsonGenerator.writeFieldName("BackupType").writeValue(backup.getBackupType());
            }
            if (backup.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("CreatedAt").writeValue(backup.getCreatedAt());
            }
            if (backup.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(backup.getDescription());
            }
            if (backup.getEngine() != null) {
                jsonGenerator.writeFieldName("Engine").writeValue(backup.getEngine());
            }
            if (backup.getEngineModel() != null) {
                jsonGenerator.writeFieldName("EngineModel").writeValue(backup.getEngineModel());
            }
            if (backup.getEngineVersion() != null) {
                jsonGenerator.writeFieldName("EngineVersion").writeValue(backup.getEngineVersion());
            }
            if (backup.getInstanceProfileArn() != null) {
                jsonGenerator.writeFieldName("InstanceProfileArn").writeValue(backup.getInstanceProfileArn());
            }
            if (backup.getInstanceType() != null) {
                jsonGenerator.writeFieldName("InstanceType").writeValue(backup.getInstanceType());
            }
            if (backup.getKeyPair() != null) {
                jsonGenerator.writeFieldName("KeyPair").writeValue(backup.getKeyPair());
            }
            if (backup.getPreferredBackupWindow() != null) {
                jsonGenerator.writeFieldName("PreferredBackupWindow").writeValue(backup.getPreferredBackupWindow());
            }
            if (backup.getPreferredMaintenanceWindow() != null) {
                jsonGenerator.writeFieldName("PreferredMaintenanceWindow").writeValue(backup.getPreferredMaintenanceWindow());
            }
            if (backup.getS3DataSize() != null) {
                jsonGenerator.writeFieldName("S3DataSize").writeValue(backup.getS3DataSize().intValue());
            }
            if (backup.getS3DataUrl() != null) {
                jsonGenerator.writeFieldName("S3DataUrl").writeValue(backup.getS3DataUrl());
            }
            if (backup.getS3LogUrl() != null) {
                jsonGenerator.writeFieldName("S3LogUrl").writeValue(backup.getS3LogUrl());
            }
            if ((securityGroupIdsList = backup.getSecurityGroupIds()) != null) {
                jsonGenerator.writeFieldName("SecurityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (backup.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(backup.getServerName());
            }
            if (backup.getServiceRoleArn() != null) {
                jsonGenerator.writeFieldName("ServiceRoleArn").writeValue(backup.getServiceRoleArn());
            }
            if (backup.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(backup.getStatus());
            }
            if (backup.getStatusDescription() != null) {
                jsonGenerator.writeFieldName("StatusDescription").writeValue(backup.getStatusDescription());
            }
            if ((subnetIdsList = backup.getSubnetIds()) != null) {
                jsonGenerator.writeFieldName("SubnetIds");
                jsonGenerator.writeStartArray();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonGenerator.writeValue(subnetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (backup.getToolsVersion() != null) {
                jsonGenerator.writeFieldName("ToolsVersion").writeValue(backup.getToolsVersion());
            }
            if (backup.getUserArn() != null) {
                jsonGenerator.writeFieldName("UserArn").writeValue(backup.getUserArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BackupJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BackupJsonMarshaller();
        }
        return instance;
    }
}

