/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworkscm.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworkscm.model.AssociateNodeRequest;
import com.amazonaws.services.opsworkscm.model.EngineAttribute;
import com.amazonaws.services.opsworkscm.model.transform.EngineAttributeJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class AssociateNodeRequestMarshaller
implements Marshaller<Request<AssociateNodeRequest>, AssociateNodeRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public AssociateNodeRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<AssociateNodeRequest> marshall(AssociateNodeRequest associateNodeRequest) {
        if (associateNodeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)associateNodeRequest, "AWSOpsWorksCM");
        request.addHeader("X-Amz-Target", "OpsWorksCM_V2016_11_01.AssociateNode");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<EngineAttribute> engineAttributesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (associateNodeRequest.getServerName() != null) {
                jsonGenerator.writeFieldName("ServerName").writeValue(associateNodeRequest.getServerName());
            }
            if (associateNodeRequest.getNodeName() != null) {
                jsonGenerator.writeFieldName("NodeName").writeValue(associateNodeRequest.getNodeName());
            }
            if ((engineAttributesList = associateNodeRequest.getEngineAttributes()) != null) {
                jsonGenerator.writeFieldName("EngineAttributes");
                jsonGenerator.writeStartArray();
                for (EngineAttribute engineAttributesListValue : engineAttributesList) {
                    if (engineAttributesListValue == null) continue;
                    EngineAttributeJsonMarshaller.getInstance().marshall(engineAttributesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

