/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;

@SdkInternalApi
public class VolumeConfigurationMarshaller {
    private static final MarshallingInfo<String> MOUNTPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MountPoint").build();
    private static final MarshallingInfo<Integer> RAIDLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RaidLevel").build();
    private static final MarshallingInfo<Integer> NUMBEROFDISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDisks").build();
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").build();
    private static final MarshallingInfo<String> VOLUMETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeType").build();
    private static final MarshallingInfo<Integer> IOPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Iops").build();
    private static final MarshallingInfo<Boolean> ENCRYPTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Encrypted").build();
    private static final VolumeConfigurationMarshaller instance = new VolumeConfigurationMarshaller();

    public static VolumeConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(VolumeConfiguration volumeConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (volumeConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)volumeConfiguration.getMountPoint(), MOUNTPOINT_BINDING);
            protocolMarshaller.marshall((Object)volumeConfiguration.getRaidLevel(), RAIDLEVEL_BINDING);
            protocolMarshaller.marshall((Object)volumeConfiguration.getNumberOfDisks(), NUMBEROFDISKS_BINDING);
            protocolMarshaller.marshall((Object)volumeConfiguration.getSize(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)volumeConfiguration.getVolumeType(), VOLUMETYPE_BINDING);
            protocolMarshaller.marshall((Object)volumeConfiguration.getIops(), IOPS_BINDING);
            protocolMarshaller.marshall((Object)volumeConfiguration.getEncrypted(), ENCRYPTED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

