/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.transform.EbsBlockDeviceJsonMarshaller;

public class BlockDeviceMappingJsonMarshaller {
    private static BlockDeviceMappingJsonMarshaller instance;

    public void marshall(BlockDeviceMapping blockDeviceMapping, StructuredJsonGenerator jsonGenerator) {
        if (blockDeviceMapping == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (blockDeviceMapping.getDeviceName() != null) {
                jsonGenerator.writeFieldName("DeviceName").writeValue(blockDeviceMapping.getDeviceName());
            }
            if (blockDeviceMapping.getNoDevice() != null) {
                jsonGenerator.writeFieldName("NoDevice").writeValue(blockDeviceMapping.getNoDevice());
            }
            if (blockDeviceMapping.getVirtualName() != null) {
                jsonGenerator.writeFieldName("VirtualName").writeValue(blockDeviceMapping.getVirtualName());
            }
            if (blockDeviceMapping.getEbs() != null) {
                jsonGenerator.writeFieldName("Ebs");
                EbsBlockDeviceJsonMarshaller.getInstance().marshall(blockDeviceMapping.getEbs(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BlockDeviceMappingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BlockDeviceMappingJsonMarshaller();
        }
        return instance;
    }
}

