/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opsworks.model.SslConfiguration;

@SdkInternalApi
public class SslConfigurationMarshaller {
    private static final MarshallingInfo<String> CERTIFICATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Certificate").build();
    private static final MarshallingInfo<String> PRIVATEKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateKey").build();
    private static final MarshallingInfo<String> CHAIN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Chain").build();
    private static final SslConfigurationMarshaller instance = new SslConfigurationMarshaller();

    public static SslConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(SslConfiguration sslConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (sslConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sslConfiguration.getCertificate(), CERTIFICATE_BINDING);
            protocolMarshaller.marshall((Object)sslConfiguration.getPrivateKey(), PRIVATEKEY_BINDING);
            protocolMarshaller.marshall((Object)sslConfiguration.getChain(), CHAIN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

