/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.Recipes;

public class RecipesJsonMarshaller {
    private static RecipesJsonMarshaller instance;

    public void marshall(Recipes recipes, StructuredJsonGenerator jsonGenerator) {
        if (recipes == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList shutdownList;
            SdkInternalList undeployList;
            SdkInternalList deployList;
            SdkInternalList configureList;
            jsonGenerator.writeStartObject();
            SdkInternalList setupList = (SdkInternalList)recipes.getSetup();
            if (!setupList.isEmpty() || !setupList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Setup");
                jsonGenerator.writeStartArray();
                for (String setupListValue : setupList) {
                    if (setupListValue == null) continue;
                    jsonGenerator.writeValue(setupListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(configureList = (SdkInternalList)recipes.getConfigure()).isEmpty() || !configureList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configure");
                jsonGenerator.writeStartArray();
                for (String configureListValue : configureList) {
                    if (configureListValue == null) continue;
                    jsonGenerator.writeValue(configureListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(deployList = (SdkInternalList)recipes.getDeploy()).isEmpty() || !deployList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Deploy");
                jsonGenerator.writeStartArray();
                for (String deployListValue : deployList) {
                    if (deployListValue == null) continue;
                    jsonGenerator.writeValue(deployListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(undeployList = (SdkInternalList)recipes.getUndeploy()).isEmpty() || !undeployList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Undeploy");
                jsonGenerator.writeStartArray();
                for (String undeployListValue : undeployList) {
                    if (undeployListValue == null) continue;
                    jsonGenerator.writeValue(undeployListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(shutdownList = (SdkInternalList)recipes.getShutdown()).isEmpty() || !shutdownList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Shutdown");
                jsonGenerator.writeStartArray();
                for (String shutdownListValue : shutdownList) {
                    if (shutdownListValue == null) continue;
                    jsonGenerator.writeValue(shutdownListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RecipesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RecipesJsonMarshaller();
        }
        return instance;
    }
}

