/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.Architecture;
import com.amazonaws.services.opsworks.model.AutoScalingType;
import com.amazonaws.services.opsworks.model.BlockDeviceMapping;
import com.amazonaws.services.opsworks.model.RootDeviceType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String stackId;
    private SdkInternalList<String> layerIds;
    private String instanceType;
    private String autoScalingType;
    private String hostname;
    private String os;
    private String amiId;
    private String sshKeyName;
    private String availabilityZone;
    private String virtualizationType;
    private String subnetId;
    private String architecture;
    private String rootDeviceType;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private Boolean installUpdatesOnBoot;
    private Boolean ebsOptimized;
    private String agentVersion;
    private String tenancy;

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public CreateInstanceRequest withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public List<String> getLayerIds() {
        if (this.layerIds == null) {
            this.layerIds = new SdkInternalList();
        }
        return this.layerIds;
    }

    public void setLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
            return;
        }
        this.layerIds = new SdkInternalList(layerIds);
    }

    public CreateInstanceRequest withLayerIds(String ... layerIds) {
        if (this.layerIds == null) {
            this.setLayerIds((Collection<String>)new SdkInternalList(layerIds.length));
        }
        for (String ele : layerIds) {
            this.layerIds.add((Object)ele);
        }
        return this;
    }

    public CreateInstanceRequest withLayerIds(Collection<String> layerIds) {
        this.setLayerIds(layerIds);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public CreateInstanceRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
    }

    public String getAutoScalingType() {
        return this.autoScalingType;
    }

    public CreateInstanceRequest withAutoScalingType(String autoScalingType) {
        this.setAutoScalingType(autoScalingType);
        return this;
    }

    @JsonIgnore
    public void setAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
    }

    public CreateInstanceRequest withAutoScalingType(AutoScalingType autoScalingType) {
        this.setAutoScalingType(autoScalingType);
        return this;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public CreateInstanceRequest withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    public CreateInstanceRequest withOs(String os) {
        this.setOs(os);
        return this;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public CreateInstanceRequest withAmiId(String amiId) {
        this.setAmiId(amiId);
        return this;
    }

    public void setSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
    }

    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public CreateInstanceRequest withSshKeyName(String sshKeyName) {
        this.setSshKeyName(sshKeyName);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public CreateInstanceRequest withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public CreateInstanceRequest withVirtualizationType(String virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public CreateInstanceRequest withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public CreateInstanceRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    @JsonIgnore
    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
    }

    public CreateInstanceRequest withArchitecture(Architecture architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public CreateInstanceRequest withRootDeviceType(String rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    @JsonIgnore
    public void setRootDeviceType(RootDeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType.toString();
    }

    public CreateInstanceRequest withRootDeviceType(RootDeviceType rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings);
    }

    public CreateInstanceRequest withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings((Collection<BlockDeviceMapping>)new SdkInternalList(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add((Object)ele);
        }
        return this;
    }

    public CreateInstanceRequest withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public CreateInstanceRequest withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.setInstallUpdatesOnBoot(installUpdatesOnBoot);
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public CreateInstanceRequest withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public CreateInstanceRequest withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public void setTenancy(String tenancy) {
        this.tenancy = tenancy;
    }

    public String getTenancy() {
        return this.tenancy;
    }

    public CreateInstanceRequest withTenancy(String tenancy) {
        this.setTenancy(tenancy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: ").append(this.getStackId()).append(",");
        }
        if (this.getLayerIds() != null) {
            sb.append("LayerIds: ").append(this.getLayerIds()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getAutoScalingType() != null) {
            sb.append("AutoScalingType: ").append(this.getAutoScalingType()).append(",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: ").append(this.getHostname()).append(",");
        }
        if (this.getOs() != null) {
            sb.append("Os: ").append(this.getOs()).append(",");
        }
        if (this.getAmiId() != null) {
            sb.append("AmiId: ").append(this.getAmiId()).append(",");
        }
        if (this.getSshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.getSshKeyName()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getVirtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.getVirtualizationType()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getRootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(this.getRootDeviceType()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.getInstallUpdatesOnBoot()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: ").append(this.getAgentVersion()).append(",");
        }
        if (this.getTenancy() != null) {
            sb.append("Tenancy: ").append(this.getTenancy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getLayerIds() == null ^ this.getLayerIds() == null) {
            return false;
        }
        if (other.getLayerIds() != null && !other.getLayerIds().equals(this.getLayerIds())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getAutoScalingType() == null ^ this.getAutoScalingType() == null) {
            return false;
        }
        if (other.getAutoScalingType() != null && !other.getAutoScalingType().equals(this.getAutoScalingType())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getOs() == null ^ this.getOs() == null) {
            return false;
        }
        if (other.getOs() != null && !other.getOs().equals(this.getOs())) {
            return false;
        }
        if (other.getAmiId() == null ^ this.getAmiId() == null) {
            return false;
        }
        if (other.getAmiId() != null && !other.getAmiId().equals(this.getAmiId())) {
            return false;
        }
        if (other.getSshKeyName() == null ^ this.getSshKeyName() == null) {
            return false;
        }
        if (other.getSshKeyName() != null && !other.getSshKeyName().equals(this.getSshKeyName())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        if (other.getVirtualizationType() != null && !other.getVirtualizationType().equals(this.getVirtualizationType())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() == null ^ this.getInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() != null && !other.getInstallUpdatesOnBoot().equals(this.getInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        if (other.getAgentVersion() != null && !other.getAgentVersion().equals(this.getAgentVersion())) {
            return false;
        }
        if (other.getTenancy() == null ^ this.getTenancy() == null) {
            return false;
        }
        return other.getTenancy() == null || other.getTenancy().equals(this.getTenancy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerIds() == null ? 0 : this.getLayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingType() == null ? 0 : this.getAutoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getOs() == null ? 0 : this.getOs().hashCode());
        hashCode = 31 * hashCode + (this.getAmiId() == null ? 0 : this.getAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getSshKeyName() == null ? 0 : this.getSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getInstallUpdatesOnBoot() == null ? 0 : this.getInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        hashCode = 31 * hashCode + (this.getTenancy() == null ? 0 : this.getTenancy().hashCode());
        return hashCode;
    }

    public CreateInstanceRequest clone() {
        return (CreateInstanceRequest)super.clone();
    }
}

