/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.CreateLayerRequest;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.services.opsworks.model.transform.LifecycleEventConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.RecipesJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.VolumeConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateLayerRequestMarshaller
implements Marshaller<Request<CreateLayerRequest>, CreateLayerRequest> {
    public Request<CreateLayerRequest> marshall(CreateLayerRequest createLayerRequest) {
        if (createLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLayerRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CreateLayer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumeConfigurationsList;
            SdkInternalList packagesList;
            SdkInternalList customSecurityGroupIdsList;
            SdkInternalMap attributesMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createLayerRequest.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)createLayerRequest.getStackId());
            }
            if (createLayerRequest.getType() != null) {
                jsonWriter.key("Type").value((Object)createLayerRequest.getType());
            }
            if (createLayerRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)createLayerRequest.getName());
            }
            if (createLayerRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value((Object)createLayerRequest.getShortname());
            }
            if (!(attributesMap = (SdkInternalMap)createLayerRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (createLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value((Object)createLayerRequest.getCustomInstanceProfileArn());
            }
            if (createLayerRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)createLayerRequest.getCustomJson());
            }
            if (!(customSecurityGroupIdsList = (SdkInternalList)createLayerRequest.getCustomSecurityGroupIds()).isEmpty() || !customSecurityGroupIdsList.isAutoConstruct()) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value((Object)customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(packagesList = (SdkInternalList)createLayerRequest.getPackages()).isEmpty() || !packagesList.isAutoConstruct()) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value((Object)packagesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(volumeConfigurationsList = (SdkInternalList)createLayerRequest.getVolumeConfigurations()).isEmpty() || !volumeConfigurationsList.isAutoConstruct()) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    VolumeConfigurationJsonMarshaller.getInstance().marshall(volumeConfigurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createLayerRequest.getEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value((Object)createLayerRequest.getEnableAutoHealing());
            }
            if (createLayerRequest.getAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value((Object)createLayerRequest.getAutoAssignElasticIps());
            }
            if (createLayerRequest.getAutoAssignPublicIps() != null) {
                jsonWriter.key("AutoAssignPublicIps").value((Object)createLayerRequest.getAutoAssignPublicIps());
            }
            if (createLayerRequest.getCustomRecipes() != null) {
                jsonWriter.key("CustomRecipes");
                RecipesJsonMarshaller.getInstance().marshall(createLayerRequest.getCustomRecipes(), jsonWriter);
            }
            if (createLayerRequest.getInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)createLayerRequest.getInstallUpdatesOnBoot());
            }
            if (createLayerRequest.getUseEbsOptimizedInstances() != null) {
                jsonWriter.key("UseEbsOptimizedInstances").value((Object)createLayerRequest.getUseEbsOptimizedInstances());
            }
            if (createLayerRequest.getLifecycleEventConfiguration() != null) {
                jsonWriter.key("LifecycleEventConfiguration");
                LifecycleEventConfigurationJsonMarshaller.getInstance().marshall(createLayerRequest.getLifecycleEventConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

