/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.Stack;
import com.amazonaws.services.opsworks.model.transform.ChefConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.StackConfigurationManagerJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class StackJsonMarshaller {
    private static StackJsonMarshaller instance;

    public void marshall(Stack stack, JSONWriter jsonWriter) {
        if (stack == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap attributesMap;
            jsonWriter.object();
            if (stack.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)stack.getStackId());
            }
            if (stack.getName() != null) {
                jsonWriter.key("Name").value((Object)stack.getName());
            }
            if (stack.getArn() != null) {
                jsonWriter.key("Arn").value((Object)stack.getArn());
            }
            if (stack.getRegion() != null) {
                jsonWriter.key("Region").value((Object)stack.getRegion());
            }
            if (stack.getVpcId() != null) {
                jsonWriter.key("VpcId").value((Object)stack.getVpcId());
            }
            if (!(attributesMap = (SdkInternalMap)stack.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (stack.getServiceRoleArn() != null) {
                jsonWriter.key("ServiceRoleArn").value((Object)stack.getServiceRoleArn());
            }
            if (stack.getDefaultInstanceProfileArn() != null) {
                jsonWriter.key("DefaultInstanceProfileArn").value((Object)stack.getDefaultInstanceProfileArn());
            }
            if (stack.getDefaultOs() != null) {
                jsonWriter.key("DefaultOs").value((Object)stack.getDefaultOs());
            }
            if (stack.getHostnameTheme() != null) {
                jsonWriter.key("HostnameTheme").value((Object)stack.getHostnameTheme());
            }
            if (stack.getDefaultAvailabilityZone() != null) {
                jsonWriter.key("DefaultAvailabilityZone").value((Object)stack.getDefaultAvailabilityZone());
            }
            if (stack.getDefaultSubnetId() != null) {
                jsonWriter.key("DefaultSubnetId").value((Object)stack.getDefaultSubnetId());
            }
            if (stack.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)stack.getCustomJson());
            }
            if (stack.getConfigurationManager() != null) {
                jsonWriter.key("ConfigurationManager");
                StackConfigurationManagerJsonMarshaller.getInstance().marshall(stack.getConfigurationManager(), jsonWriter);
            }
            if (stack.getChefConfiguration() != null) {
                jsonWriter.key("ChefConfiguration");
                ChefConfigurationJsonMarshaller.getInstance().marshall(stack.getChefConfiguration(), jsonWriter);
            }
            if (stack.getUseCustomCookbooks() != null) {
                jsonWriter.key("UseCustomCookbooks").value((Object)stack.getUseCustomCookbooks());
            }
            if (stack.getUseOpsworksSecurityGroups() != null) {
                jsonWriter.key("UseOpsworksSecurityGroups").value((Object)stack.getUseOpsworksSecurityGroups());
            }
            if (stack.getCustomCookbooksSource() != null) {
                jsonWriter.key("CustomCookbooksSource");
                SourceJsonMarshaller.getInstance().marshall(stack.getCustomCookbooksSource(), jsonWriter);
            }
            if (stack.getDefaultSshKeyName() != null) {
                jsonWriter.key("DefaultSshKeyName").value((Object)stack.getDefaultSshKeyName());
            }
            if (stack.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value((Object)stack.getCreatedAt());
            }
            if (stack.getDefaultRootDeviceType() != null) {
                jsonWriter.key("DefaultRootDeviceType").value((Object)stack.getDefaultRootDeviceType());
            }
            if (stack.getAgentVersion() != null) {
                jsonWriter.key("AgentVersion").value((Object)stack.getAgentVersion());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StackJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StackJsonMarshaller();
        }
        return instance;
    }
}

