/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.Deployment;
import com.amazonaws.services.opsworks.model.transform.DeploymentCommandJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DeploymentJsonMarshaller {
    private static DeploymentJsonMarshaller instance;

    public void marshall(Deployment deployment, JSONWriter jsonWriter) {
        if (deployment == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList instanceIdsList;
            jsonWriter.object();
            if (deployment.getDeploymentId() != null) {
                jsonWriter.key("DeploymentId").value((Object)deployment.getDeploymentId());
            }
            if (deployment.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)deployment.getStackId());
            }
            if (deployment.getAppId() != null) {
                jsonWriter.key("AppId").value((Object)deployment.getAppId());
            }
            if (deployment.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value((Object)deployment.getCreatedAt());
            }
            if (deployment.getCompletedAt() != null) {
                jsonWriter.key("CompletedAt").value((Object)deployment.getCompletedAt());
            }
            if (deployment.getDuration() != null) {
                jsonWriter.key("Duration").value((Object)deployment.getDuration());
            }
            if (deployment.getIamUserArn() != null) {
                jsonWriter.key("IamUserArn").value((Object)deployment.getIamUserArn());
            }
            if (deployment.getComment() != null) {
                jsonWriter.key("Comment").value((Object)deployment.getComment());
            }
            if (deployment.getCommand() != null) {
                jsonWriter.key("Command");
                DeploymentCommandJsonMarshaller.getInstance().marshall(deployment.getCommand(), jsonWriter);
            }
            if (deployment.getStatus() != null) {
                jsonWriter.key("Status").value((Object)deployment.getStatus());
            }
            if (deployment.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)deployment.getCustomJson());
            }
            if (!(instanceIdsList = (SdkInternalList)deployment.getInstanceIds()).isEmpty() || !instanceIdsList.isAutoConstruct()) {
                jsonWriter.key("InstanceIds");
                jsonWriter.array();
                for (String instanceIdsListValue : instanceIdsList) {
                    if (instanceIdsListValue == null) continue;
                    jsonWriter.value((Object)instanceIdsListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentJsonMarshaller();
        }
        return instance;
    }
}

