/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.opsworks.model.StackSummary;
import com.amazonaws.services.opsworks.model.transform.InstancesCountJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class StackSummaryJsonMarshaller {
    private static StackSummaryJsonMarshaller instance;

    public void marshall(StackSummary stackSummary, JSONWriter jsonWriter) {
        if (stackSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (stackSummary.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)stackSummary.getStackId());
            }
            if (stackSummary.getName() != null) {
                jsonWriter.key("Name").value((Object)stackSummary.getName());
            }
            if (stackSummary.getArn() != null) {
                jsonWriter.key("Arn").value((Object)stackSummary.getArn());
            }
            if (stackSummary.getLayersCount() != null) {
                jsonWriter.key("LayersCount").value((Object)stackSummary.getLayersCount());
            }
            if (stackSummary.getAppsCount() != null) {
                jsonWriter.key("AppsCount").value((Object)stackSummary.getAppsCount());
            }
            if (stackSummary.getInstancesCount() != null) {
                jsonWriter.key("InstancesCount");
                InstancesCountJsonMarshaller.getInstance().marshall(stackSummary.getInstancesCount(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StackSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StackSummaryJsonMarshaller();
        }
        return instance;
    }
}

