/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.Layer;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.services.opsworks.model.transform.LifecycleEventConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.RecipesJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.VolumeConfigurationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class LayerJsonMarshaller {
    private static LayerJsonMarshaller instance;

    public void marshall(Layer layer, JSONWriter jsonWriter) {
        if (layer == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList volumeConfigurationsList;
            SdkInternalList packagesList;
            SdkInternalList defaultSecurityGroupNamesList;
            SdkInternalList customSecurityGroupIdsList;
            SdkInternalMap attributesMap;
            jsonWriter.object();
            if (layer.getStackId() != null) {
                jsonWriter.key("StackId").value((Object)layer.getStackId());
            }
            if (layer.getLayerId() != null) {
                jsonWriter.key("LayerId").value((Object)layer.getLayerId());
            }
            if (layer.getType() != null) {
                jsonWriter.key("Type").value((Object)layer.getType());
            }
            if (layer.getName() != null) {
                jsonWriter.key("Name").value((Object)layer.getName());
            }
            if (layer.getShortname() != null) {
                jsonWriter.key("Shortname").value((Object)layer.getShortname());
            }
            if (!(attributesMap = (SdkInternalMap)layer.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (layer.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value((Object)layer.getCustomInstanceProfileArn());
            }
            if (layer.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)layer.getCustomJson());
            }
            if (!(customSecurityGroupIdsList = (SdkInternalList)layer.getCustomSecurityGroupIds()).isEmpty() || !customSecurityGroupIdsList.isAutoConstruct()) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value((Object)customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(defaultSecurityGroupNamesList = (SdkInternalList)layer.getDefaultSecurityGroupNames()).isEmpty() || !defaultSecurityGroupNamesList.isAutoConstruct()) {
                jsonWriter.key("DefaultSecurityGroupNames");
                jsonWriter.array();
                for (String defaultSecurityGroupNamesListValue : defaultSecurityGroupNamesList) {
                    if (defaultSecurityGroupNamesListValue == null) continue;
                    jsonWriter.value((Object)defaultSecurityGroupNamesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(packagesList = (SdkInternalList)layer.getPackages()).isEmpty() || !packagesList.isAutoConstruct()) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value((Object)packagesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(volumeConfigurationsList = (SdkInternalList)layer.getVolumeConfigurations()).isEmpty() || !volumeConfigurationsList.isAutoConstruct()) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    VolumeConfigurationJsonMarshaller.getInstance().marshall(volumeConfigurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (layer.getEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value((Object)layer.getEnableAutoHealing());
            }
            if (layer.getAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value((Object)layer.getAutoAssignElasticIps());
            }
            if (layer.getAutoAssignPublicIps() != null) {
                jsonWriter.key("AutoAssignPublicIps").value((Object)layer.getAutoAssignPublicIps());
            }
            if (layer.getDefaultRecipes() != null) {
                jsonWriter.key("DefaultRecipes");
                RecipesJsonMarshaller.getInstance().marshall(layer.getDefaultRecipes(), jsonWriter);
            }
            if (layer.getCustomRecipes() != null) {
                jsonWriter.key("CustomRecipes");
                RecipesJsonMarshaller.getInstance().marshall(layer.getCustomRecipes(), jsonWriter);
            }
            if (layer.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value((Object)layer.getCreatedAt());
            }
            if (layer.getInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)layer.getInstallUpdatesOnBoot());
            }
            if (layer.getUseEbsOptimizedInstances() != null) {
                jsonWriter.key("UseEbsOptimizedInstances").value((Object)layer.getUseEbsOptimizedInstances());
            }
            if (layer.getLifecycleEventConfiguration() != null) {
                jsonWriter.key("LifecycleEventConfiguration");
                LifecycleEventConfigurationJsonMarshaller.getInstance().marshall(layer.getLifecycleEventConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LayerJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LayerJsonMarshaller();
        }
        return instance;
    }
}

