/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.CloneStackRequest;
import com.amazonaws.services.opsworks.model.transform.ChefConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.SourceJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.StackConfigurationManagerJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CloneStackRequestMarshaller
implements Marshaller<Request<CloneStackRequest>, CloneStackRequest> {
    public Request<CloneStackRequest> marshall(CloneStackRequest cloneStackRequest) {
        if (cloneStackRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cloneStackRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.CloneStack");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList cloneAppIdsList;
            SdkInternalMap attributesMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (cloneStackRequest.getSourceStackId() != null) {
                jsonWriter.key("SourceStackId").value((Object)cloneStackRequest.getSourceStackId());
            }
            if (cloneStackRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)cloneStackRequest.getName());
            }
            if (cloneStackRequest.getRegion() != null) {
                jsonWriter.key("Region").value((Object)cloneStackRequest.getRegion());
            }
            if (cloneStackRequest.getVpcId() != null) {
                jsonWriter.key("VpcId").value((Object)cloneStackRequest.getVpcId());
            }
            if (!(attributesMap = (SdkInternalMap)cloneStackRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (cloneStackRequest.getServiceRoleArn() != null) {
                jsonWriter.key("ServiceRoleArn").value((Object)cloneStackRequest.getServiceRoleArn());
            }
            if (cloneStackRequest.getDefaultInstanceProfileArn() != null) {
                jsonWriter.key("DefaultInstanceProfileArn").value((Object)cloneStackRequest.getDefaultInstanceProfileArn());
            }
            if (cloneStackRequest.getDefaultOs() != null) {
                jsonWriter.key("DefaultOs").value((Object)cloneStackRequest.getDefaultOs());
            }
            if (cloneStackRequest.getHostnameTheme() != null) {
                jsonWriter.key("HostnameTheme").value((Object)cloneStackRequest.getHostnameTheme());
            }
            if (cloneStackRequest.getDefaultAvailabilityZone() != null) {
                jsonWriter.key("DefaultAvailabilityZone").value((Object)cloneStackRequest.getDefaultAvailabilityZone());
            }
            if (cloneStackRequest.getDefaultSubnetId() != null) {
                jsonWriter.key("DefaultSubnetId").value((Object)cloneStackRequest.getDefaultSubnetId());
            }
            if (cloneStackRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)cloneStackRequest.getCustomJson());
            }
            if (cloneStackRequest.getConfigurationManager() != null) {
                jsonWriter.key("ConfigurationManager");
                StackConfigurationManagerJsonMarshaller.getInstance().marshall(cloneStackRequest.getConfigurationManager(), jsonWriter);
            }
            if (cloneStackRequest.getChefConfiguration() != null) {
                jsonWriter.key("ChefConfiguration");
                ChefConfigurationJsonMarshaller.getInstance().marshall(cloneStackRequest.getChefConfiguration(), jsonWriter);
            }
            if (cloneStackRequest.getUseCustomCookbooks() != null) {
                jsonWriter.key("UseCustomCookbooks").value((Object)cloneStackRequest.getUseCustomCookbooks());
            }
            if (cloneStackRequest.getUseOpsworksSecurityGroups() != null) {
                jsonWriter.key("UseOpsworksSecurityGroups").value((Object)cloneStackRequest.getUseOpsworksSecurityGroups());
            }
            if (cloneStackRequest.getCustomCookbooksSource() != null) {
                jsonWriter.key("CustomCookbooksSource");
                SourceJsonMarshaller.getInstance().marshall(cloneStackRequest.getCustomCookbooksSource(), jsonWriter);
            }
            if (cloneStackRequest.getDefaultSshKeyName() != null) {
                jsonWriter.key("DefaultSshKeyName").value((Object)cloneStackRequest.getDefaultSshKeyName());
            }
            if (cloneStackRequest.getClonePermissions() != null) {
                jsonWriter.key("ClonePermissions").value((Object)cloneStackRequest.getClonePermissions());
            }
            if (!(cloneAppIdsList = (SdkInternalList)cloneStackRequest.getCloneAppIds()).isEmpty() || !cloneAppIdsList.isAutoConstruct()) {
                jsonWriter.key("CloneAppIds");
                jsonWriter.array();
                for (String cloneAppIdsListValue : cloneAppIdsList) {
                    if (cloneAppIdsListValue == null) continue;
                    jsonWriter.value((Object)cloneAppIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (cloneStackRequest.getDefaultRootDeviceType() != null) {
                jsonWriter.key("DefaultRootDeviceType").value((Object)cloneStackRequest.getDefaultRootDeviceType());
            }
            if (cloneStackRequest.getAgentVersion() != null) {
                jsonWriter.key("AgentVersion").value((Object)cloneStackRequest.getAgentVersion());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

