/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.opsworks.model.UpdateLayerRequest;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.services.opsworks.model.transform.LifecycleEventConfigurationJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.RecipesJsonMarshaller;
import com.amazonaws.services.opsworks.model.transform.VolumeConfigurationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class UpdateLayerRequestMarshaller
implements Marshaller<Request<UpdateLayerRequest>, UpdateLayerRequest> {
    public Request<UpdateLayerRequest> marshall(UpdateLayerRequest updateLayerRequest) {
        if (updateLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateLayerRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.UpdateLayer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList volumeConfigurationsList;
            SdkInternalList packagesList;
            SdkInternalList customSecurityGroupIdsList;
            SdkInternalMap attributesMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateLayerRequest.getLayerId() != null) {
                jsonWriter.key("LayerId").value((Object)updateLayerRequest.getLayerId());
            }
            if (updateLayerRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)updateLayerRequest.getName());
            }
            if (updateLayerRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value((Object)updateLayerRequest.getShortname());
            }
            if (!(attributesMap = (SdkInternalMap)updateLayerRequest.getAttributes()).isEmpty() || !attributesMap.isAutoConstruct()) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry attributesMapValue : attributesMap.entrySet()) {
                    if (attributesMapValue.getValue() == null) continue;
                    jsonWriter.key((String)attributesMapValue.getKey());
                    jsonWriter.value(attributesMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (updateLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value((Object)updateLayerRequest.getCustomInstanceProfileArn());
            }
            if (updateLayerRequest.getCustomJson() != null) {
                jsonWriter.key("CustomJson").value((Object)updateLayerRequest.getCustomJson());
            }
            if (!(customSecurityGroupIdsList = (SdkInternalList)updateLayerRequest.getCustomSecurityGroupIds()).isEmpty() || !customSecurityGroupIdsList.isAutoConstruct()) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value((Object)customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(packagesList = (SdkInternalList)updateLayerRequest.getPackages()).isEmpty() || !packagesList.isAutoConstruct()) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value((Object)packagesListValue);
                }
                jsonWriter.endArray();
            }
            if (!(volumeConfigurationsList = (SdkInternalList)updateLayerRequest.getVolumeConfigurations()).isEmpty() || !volumeConfigurationsList.isAutoConstruct()) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    VolumeConfigurationJsonMarshaller.getInstance().marshall(volumeConfigurationsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (updateLayerRequest.getEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value((Object)updateLayerRequest.getEnableAutoHealing());
            }
            if (updateLayerRequest.getAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value((Object)updateLayerRequest.getAutoAssignElasticIps());
            }
            if (updateLayerRequest.getAutoAssignPublicIps() != null) {
                jsonWriter.key("AutoAssignPublicIps").value((Object)updateLayerRequest.getAutoAssignPublicIps());
            }
            if (updateLayerRequest.getCustomRecipes() != null) {
                jsonWriter.key("CustomRecipes");
                RecipesJsonMarshaller.getInstance().marshall(updateLayerRequest.getCustomRecipes(), jsonWriter);
            }
            if (updateLayerRequest.getInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)updateLayerRequest.getInstallUpdatesOnBoot());
            }
            if (updateLayerRequest.getUseEbsOptimizedInstances() != null) {
                jsonWriter.key("UseEbsOptimizedInstances").value((Object)updateLayerRequest.getUseEbsOptimizedInstances());
            }
            if (updateLayerRequest.getLifecycleEventConfiguration() != null) {
                jsonWriter.key("LifecycleEventConfiguration");
                LifecycleEventConfigurationJsonMarshaller.getInstance().marshall(updateLayerRequest.getLifecycleEventConfiguration(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

