/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opensearch.model.SAMLIdp;

@SdkInternalApi
public class SAMLIdpMarshaller {
    private static final MarshallingInfo<String> METADATACONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetadataContent").build();
    private static final MarshallingInfo<String> ENTITYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EntityId").build();
    private static final SAMLIdpMarshaller instance = new SAMLIdpMarshaller();

    public static SAMLIdpMarshaller getInstance() {
        return instance;
    }

    public void marshall(SAMLIdp sAMLIdp, ProtocolMarshaller protocolMarshaller) {
        if (sAMLIdp == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sAMLIdp.getMetadataContent(), METADATACONTENT_BINDING);
            protocolMarshaller.marshall((Object)sAMLIdp.getEntityId(), ENTITYID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

