/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opensearch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opensearch.model.AdvancedSecurityOptions;
import com.amazonaws.services.opensearch.model.AutoTuneOptionsOutput;
import com.amazonaws.services.opensearch.model.ChangeProgressDetails;
import com.amazonaws.services.opensearch.model.ClusterConfig;
import com.amazonaws.services.opensearch.model.CognitoOptions;
import com.amazonaws.services.opensearch.model.DomainEndpointOptions;
import com.amazonaws.services.opensearch.model.EBSOptions;
import com.amazonaws.services.opensearch.model.EncryptionAtRestOptions;
import com.amazonaws.services.opensearch.model.LogPublishingOption;
import com.amazonaws.services.opensearch.model.NodeToNodeEncryptionOptions;
import com.amazonaws.services.opensearch.model.ServiceSoftwareOptions;
import com.amazonaws.services.opensearch.model.SnapshotOptions;
import com.amazonaws.services.opensearch.model.VPCDerivedInfo;
import com.amazonaws.services.opensearch.model.transform.DomainStatusMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class DomainStatus
implements Serializable,
Cloneable,
StructuredPojo {
    private String domainId;
    private String domainName;
    private String aRN;
    private Boolean created;
    private Boolean deleted;
    private String endpoint;
    private Map<String, String> endpoints;
    private Boolean processing;
    private Boolean upgradeProcessing;
    private String engineVersion;
    private ClusterConfig clusterConfig;
    private EBSOptions eBSOptions;
    private String accessPolicies;
    private SnapshotOptions snapshotOptions;
    private VPCDerivedInfo vPCOptions;
    private CognitoOptions cognitoOptions;
    private EncryptionAtRestOptions encryptionAtRestOptions;
    private NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions;
    private Map<String, String> advancedOptions;
    private Map<String, LogPublishingOption> logPublishingOptions;
    private ServiceSoftwareOptions serviceSoftwareOptions;
    private DomainEndpointOptions domainEndpointOptions;
    private AdvancedSecurityOptions advancedSecurityOptions;
    private AutoTuneOptionsOutput autoTuneOptions;
    private ChangeProgressDetails changeProgressDetails;

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public DomainStatus withDomainId(String domainId) {
        this.setDomainId(domainId);
        return this;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public DomainStatus withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setARN(String aRN) {
        this.aRN = aRN;
    }

    public String getARN() {
        return this.aRN;
    }

    public DomainStatus withARN(String aRN) {
        this.setARN(aRN);
        return this;
    }

    public void setCreated(Boolean created) {
        this.created = created;
    }

    public Boolean getCreated() {
        return this.created;
    }

    public DomainStatus withCreated(Boolean created) {
        this.setCreated(created);
        return this;
    }

    public Boolean isCreated() {
        return this.created;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public DomainStatus withDeleted(Boolean deleted) {
        this.setDeleted(deleted);
        return this;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public DomainStatus withEndpoint(String endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public Map<String, String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<String, String> endpoints) {
        this.endpoints = endpoints;
    }

    public DomainStatus withEndpoints(Map<String, String> endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public DomainStatus addEndpointsEntry(String key, String value) {
        if (null == this.endpoints) {
            this.endpoints = new HashMap<String, String>();
        }
        if (this.endpoints.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.endpoints.put(key, value);
        return this;
    }

    public DomainStatus clearEndpointsEntries() {
        this.endpoints = null;
        return this;
    }

    public void setProcessing(Boolean processing) {
        this.processing = processing;
    }

    public Boolean getProcessing() {
        return this.processing;
    }

    public DomainStatus withProcessing(Boolean processing) {
        this.setProcessing(processing);
        return this;
    }

    public Boolean isProcessing() {
        return this.processing;
    }

    public void setUpgradeProcessing(Boolean upgradeProcessing) {
        this.upgradeProcessing = upgradeProcessing;
    }

    public Boolean getUpgradeProcessing() {
        return this.upgradeProcessing;
    }

    public DomainStatus withUpgradeProcessing(Boolean upgradeProcessing) {
        this.setUpgradeProcessing(upgradeProcessing);
        return this;
    }

    public Boolean isUpgradeProcessing() {
        return this.upgradeProcessing;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public DomainStatus withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public ClusterConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public DomainStatus withClusterConfig(ClusterConfig clusterConfig) {
        this.setClusterConfig(clusterConfig);
        return this;
    }

    public void setEBSOptions(EBSOptions eBSOptions) {
        this.eBSOptions = eBSOptions;
    }

    public EBSOptions getEBSOptions() {
        return this.eBSOptions;
    }

    public DomainStatus withEBSOptions(EBSOptions eBSOptions) {
        this.setEBSOptions(eBSOptions);
        return this;
    }

    public void setAccessPolicies(String accessPolicies) {
        this.accessPolicies = accessPolicies;
    }

    public String getAccessPolicies() {
        return this.accessPolicies;
    }

    public DomainStatus withAccessPolicies(String accessPolicies) {
        this.setAccessPolicies(accessPolicies);
        return this;
    }

    public void setSnapshotOptions(SnapshotOptions snapshotOptions) {
        this.snapshotOptions = snapshotOptions;
    }

    public SnapshotOptions getSnapshotOptions() {
        return this.snapshotOptions;
    }

    public DomainStatus withSnapshotOptions(SnapshotOptions snapshotOptions) {
        this.setSnapshotOptions(snapshotOptions);
        return this;
    }

    public void setVPCOptions(VPCDerivedInfo vPCOptions) {
        this.vPCOptions = vPCOptions;
    }

    public VPCDerivedInfo getVPCOptions() {
        return this.vPCOptions;
    }

    public DomainStatus withVPCOptions(VPCDerivedInfo vPCOptions) {
        this.setVPCOptions(vPCOptions);
        return this;
    }

    public void setCognitoOptions(CognitoOptions cognitoOptions) {
        this.cognitoOptions = cognitoOptions;
    }

    public CognitoOptions getCognitoOptions() {
        return this.cognitoOptions;
    }

    public DomainStatus withCognitoOptions(CognitoOptions cognitoOptions) {
        this.setCognitoOptions(cognitoOptions);
        return this;
    }

    public void setEncryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
        this.encryptionAtRestOptions = encryptionAtRestOptions;
    }

    public EncryptionAtRestOptions getEncryptionAtRestOptions() {
        return this.encryptionAtRestOptions;
    }

    public DomainStatus withEncryptionAtRestOptions(EncryptionAtRestOptions encryptionAtRestOptions) {
        this.setEncryptionAtRestOptions(encryptionAtRestOptions);
        return this;
    }

    public void setNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
        this.nodeToNodeEncryptionOptions = nodeToNodeEncryptionOptions;
    }

    public NodeToNodeEncryptionOptions getNodeToNodeEncryptionOptions() {
        return this.nodeToNodeEncryptionOptions;
    }

    public DomainStatus withNodeToNodeEncryptionOptions(NodeToNodeEncryptionOptions nodeToNodeEncryptionOptions) {
        this.setNodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
        return this;
    }

    public Map<String, String> getAdvancedOptions() {
        return this.advancedOptions;
    }

    public void setAdvancedOptions(Map<String, String> advancedOptions) {
        this.advancedOptions = advancedOptions;
    }

    public DomainStatus withAdvancedOptions(Map<String, String> advancedOptions) {
        this.setAdvancedOptions(advancedOptions);
        return this;
    }

    public DomainStatus addAdvancedOptionsEntry(String key, String value) {
        if (null == this.advancedOptions) {
            this.advancedOptions = new HashMap<String, String>();
        }
        if (this.advancedOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.advancedOptions.put(key, value);
        return this;
    }

    public DomainStatus clearAdvancedOptionsEntries() {
        this.advancedOptions = null;
        return this;
    }

    public Map<String, LogPublishingOption> getLogPublishingOptions() {
        return this.logPublishingOptions;
    }

    public void setLogPublishingOptions(Map<String, LogPublishingOption> logPublishingOptions) {
        this.logPublishingOptions = logPublishingOptions;
    }

    public DomainStatus withLogPublishingOptions(Map<String, LogPublishingOption> logPublishingOptions) {
        this.setLogPublishingOptions(logPublishingOptions);
        return this;
    }

    public DomainStatus addLogPublishingOptionsEntry(String key, LogPublishingOption value) {
        if (null == this.logPublishingOptions) {
            this.logPublishingOptions = new HashMap<String, LogPublishingOption>();
        }
        if (this.logPublishingOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.logPublishingOptions.put(key, value);
        return this;
    }

    public DomainStatus clearLogPublishingOptionsEntries() {
        this.logPublishingOptions = null;
        return this;
    }

    public void setServiceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions) {
        this.serviceSoftwareOptions = serviceSoftwareOptions;
    }

    public ServiceSoftwareOptions getServiceSoftwareOptions() {
        return this.serviceSoftwareOptions;
    }

    public DomainStatus withServiceSoftwareOptions(ServiceSoftwareOptions serviceSoftwareOptions) {
        this.setServiceSoftwareOptions(serviceSoftwareOptions);
        return this;
    }

    public void setDomainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
        this.domainEndpointOptions = domainEndpointOptions;
    }

    public DomainEndpointOptions getDomainEndpointOptions() {
        return this.domainEndpointOptions;
    }

    public DomainStatus withDomainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
        this.setDomainEndpointOptions(domainEndpointOptions);
        return this;
    }

    public void setAdvancedSecurityOptions(AdvancedSecurityOptions advancedSecurityOptions) {
        this.advancedSecurityOptions = advancedSecurityOptions;
    }

    public AdvancedSecurityOptions getAdvancedSecurityOptions() {
        return this.advancedSecurityOptions;
    }

    public DomainStatus withAdvancedSecurityOptions(AdvancedSecurityOptions advancedSecurityOptions) {
        this.setAdvancedSecurityOptions(advancedSecurityOptions);
        return this;
    }

    public void setAutoTuneOptions(AutoTuneOptionsOutput autoTuneOptions) {
        this.autoTuneOptions = autoTuneOptions;
    }

    public AutoTuneOptionsOutput getAutoTuneOptions() {
        return this.autoTuneOptions;
    }

    public DomainStatus withAutoTuneOptions(AutoTuneOptionsOutput autoTuneOptions) {
        this.setAutoTuneOptions(autoTuneOptions);
        return this;
    }

    public void setChangeProgressDetails(ChangeProgressDetails changeProgressDetails) {
        this.changeProgressDetails = changeProgressDetails;
    }

    public ChangeProgressDetails getChangeProgressDetails() {
        return this.changeProgressDetails;
    }

    public DomainStatus withChangeProgressDetails(ChangeProgressDetails changeProgressDetails) {
        this.setChangeProgressDetails(changeProgressDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainId() != null) {
            sb.append("DomainId: ").append(this.getDomainId()).append(",");
        }
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getARN() != null) {
            sb.append("ARN: ").append(this.getARN()).append(",");
        }
        if (this.getCreated() != null) {
            sb.append("Created: ").append(this.getCreated()).append(",");
        }
        if (this.getDeleted() != null) {
            sb.append("Deleted: ").append(this.getDeleted()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints()).append(",");
        }
        if (this.getProcessing() != null) {
            sb.append("Processing: ").append(this.getProcessing()).append(",");
        }
        if (this.getUpgradeProcessing() != null) {
            sb.append("UpgradeProcessing: ").append(this.getUpgradeProcessing()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getClusterConfig() != null) {
            sb.append("ClusterConfig: ").append(this.getClusterConfig()).append(",");
        }
        if (this.getEBSOptions() != null) {
            sb.append("EBSOptions: ").append(this.getEBSOptions()).append(",");
        }
        if (this.getAccessPolicies() != null) {
            sb.append("AccessPolicies: ").append(this.getAccessPolicies()).append(",");
        }
        if (this.getSnapshotOptions() != null) {
            sb.append("SnapshotOptions: ").append(this.getSnapshotOptions()).append(",");
        }
        if (this.getVPCOptions() != null) {
            sb.append("VPCOptions: ").append(this.getVPCOptions()).append(",");
        }
        if (this.getCognitoOptions() != null) {
            sb.append("CognitoOptions: ").append(this.getCognitoOptions()).append(",");
        }
        if (this.getEncryptionAtRestOptions() != null) {
            sb.append("EncryptionAtRestOptions: ").append(this.getEncryptionAtRestOptions()).append(",");
        }
        if (this.getNodeToNodeEncryptionOptions() != null) {
            sb.append("NodeToNodeEncryptionOptions: ").append(this.getNodeToNodeEncryptionOptions()).append(",");
        }
        if (this.getAdvancedOptions() != null) {
            sb.append("AdvancedOptions: ").append(this.getAdvancedOptions()).append(",");
        }
        if (this.getLogPublishingOptions() != null) {
            sb.append("LogPublishingOptions: ").append(this.getLogPublishingOptions()).append(",");
        }
        if (this.getServiceSoftwareOptions() != null) {
            sb.append("ServiceSoftwareOptions: ").append(this.getServiceSoftwareOptions()).append(",");
        }
        if (this.getDomainEndpointOptions() != null) {
            sb.append("DomainEndpointOptions: ").append(this.getDomainEndpointOptions()).append(",");
        }
        if (this.getAdvancedSecurityOptions() != null) {
            sb.append("AdvancedSecurityOptions: ").append(this.getAdvancedSecurityOptions()).append(",");
        }
        if (this.getAutoTuneOptions() != null) {
            sb.append("AutoTuneOptions: ").append(this.getAutoTuneOptions()).append(",");
        }
        if (this.getChangeProgressDetails() != null) {
            sb.append("ChangeProgressDetails: ").append(this.getChangeProgressDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStatus)) {
            return false;
        }
        DomainStatus other = (DomainStatus)obj;
        if (other.getDomainId() == null ^ this.getDomainId() == null) {
            return false;
        }
        if (other.getDomainId() != null && !other.getDomainId().equals(this.getDomainId())) {
            return false;
        }
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getARN() == null ^ this.getARN() == null) {
            return false;
        }
        if (other.getARN() != null && !other.getARN().equals(this.getARN())) {
            return false;
        }
        if (other.getCreated() == null ^ this.getCreated() == null) {
            return false;
        }
        if (other.getCreated() != null && !other.getCreated().equals(this.getCreated())) {
            return false;
        }
        if (other.getDeleted() == null ^ this.getDeleted() == null) {
            return false;
        }
        if (other.getDeleted() != null && !other.getDeleted().equals(this.getDeleted())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        if (other.getEndpoints() != null && !other.getEndpoints().equals(this.getEndpoints())) {
            return false;
        }
        if (other.getProcessing() == null ^ this.getProcessing() == null) {
            return false;
        }
        if (other.getProcessing() != null && !other.getProcessing().equals(this.getProcessing())) {
            return false;
        }
        if (other.getUpgradeProcessing() == null ^ this.getUpgradeProcessing() == null) {
            return false;
        }
        if (other.getUpgradeProcessing() != null && !other.getUpgradeProcessing().equals(this.getUpgradeProcessing())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getClusterConfig() == null ^ this.getClusterConfig() == null) {
            return false;
        }
        if (other.getClusterConfig() != null && !other.getClusterConfig().equals(this.getClusterConfig())) {
            return false;
        }
        if (other.getEBSOptions() == null ^ this.getEBSOptions() == null) {
            return false;
        }
        if (other.getEBSOptions() != null && !other.getEBSOptions().equals(this.getEBSOptions())) {
            return false;
        }
        if (other.getAccessPolicies() == null ^ this.getAccessPolicies() == null) {
            return false;
        }
        if (other.getAccessPolicies() != null && !other.getAccessPolicies().equals(this.getAccessPolicies())) {
            return false;
        }
        if (other.getSnapshotOptions() == null ^ this.getSnapshotOptions() == null) {
            return false;
        }
        if (other.getSnapshotOptions() != null && !other.getSnapshotOptions().equals(this.getSnapshotOptions())) {
            return false;
        }
        if (other.getVPCOptions() == null ^ this.getVPCOptions() == null) {
            return false;
        }
        if (other.getVPCOptions() != null && !other.getVPCOptions().equals(this.getVPCOptions())) {
            return false;
        }
        if (other.getCognitoOptions() == null ^ this.getCognitoOptions() == null) {
            return false;
        }
        if (other.getCognitoOptions() != null && !other.getCognitoOptions().equals(this.getCognitoOptions())) {
            return false;
        }
        if (other.getEncryptionAtRestOptions() == null ^ this.getEncryptionAtRestOptions() == null) {
            return false;
        }
        if (other.getEncryptionAtRestOptions() != null && !other.getEncryptionAtRestOptions().equals(this.getEncryptionAtRestOptions())) {
            return false;
        }
        if (other.getNodeToNodeEncryptionOptions() == null ^ this.getNodeToNodeEncryptionOptions() == null) {
            return false;
        }
        if (other.getNodeToNodeEncryptionOptions() != null && !other.getNodeToNodeEncryptionOptions().equals(this.getNodeToNodeEncryptionOptions())) {
            return false;
        }
        if (other.getAdvancedOptions() == null ^ this.getAdvancedOptions() == null) {
            return false;
        }
        if (other.getAdvancedOptions() != null && !other.getAdvancedOptions().equals(this.getAdvancedOptions())) {
            return false;
        }
        if (other.getLogPublishingOptions() == null ^ this.getLogPublishingOptions() == null) {
            return false;
        }
        if (other.getLogPublishingOptions() != null && !other.getLogPublishingOptions().equals(this.getLogPublishingOptions())) {
            return false;
        }
        if (other.getServiceSoftwareOptions() == null ^ this.getServiceSoftwareOptions() == null) {
            return false;
        }
        if (other.getServiceSoftwareOptions() != null && !other.getServiceSoftwareOptions().equals(this.getServiceSoftwareOptions())) {
            return false;
        }
        if (other.getDomainEndpointOptions() == null ^ this.getDomainEndpointOptions() == null) {
            return false;
        }
        if (other.getDomainEndpointOptions() != null && !other.getDomainEndpointOptions().equals(this.getDomainEndpointOptions())) {
            return false;
        }
        if (other.getAdvancedSecurityOptions() == null ^ this.getAdvancedSecurityOptions() == null) {
            return false;
        }
        if (other.getAdvancedSecurityOptions() != null && !other.getAdvancedSecurityOptions().equals(this.getAdvancedSecurityOptions())) {
            return false;
        }
        if (other.getAutoTuneOptions() == null ^ this.getAutoTuneOptions() == null) {
            return false;
        }
        if (other.getAutoTuneOptions() != null && !other.getAutoTuneOptions().equals(this.getAutoTuneOptions())) {
            return false;
        }
        if (other.getChangeProgressDetails() == null ^ this.getChangeProgressDetails() == null) {
            return false;
        }
        return other.getChangeProgressDetails() == null || other.getChangeProgressDetails().equals(this.getChangeProgressDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainId() == null ? 0 : this.getDomainId().hashCode());
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getARN() == null ? 0 : this.getARN().hashCode());
        hashCode = 31 * hashCode + (this.getCreated() == null ? 0 : this.getCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDeleted() == null ? 0 : this.getDeleted().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getProcessing() == null ? 0 : this.getProcessing().hashCode());
        hashCode = 31 * hashCode + (this.getUpgradeProcessing() == null ? 0 : this.getUpgradeProcessing().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getClusterConfig() == null ? 0 : this.getClusterConfig().hashCode());
        hashCode = 31 * hashCode + (this.getEBSOptions() == null ? 0 : this.getEBSOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAccessPolicies() == null ? 0 : this.getAccessPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotOptions() == null ? 0 : this.getSnapshotOptions().hashCode());
        hashCode = 31 * hashCode + (this.getVPCOptions() == null ? 0 : this.getVPCOptions().hashCode());
        hashCode = 31 * hashCode + (this.getCognitoOptions() == null ? 0 : this.getCognitoOptions().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionAtRestOptions() == null ? 0 : this.getEncryptionAtRestOptions().hashCode());
        hashCode = 31 * hashCode + (this.getNodeToNodeEncryptionOptions() == null ? 0 : this.getNodeToNodeEncryptionOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAdvancedOptions() == null ? 0 : this.getAdvancedOptions().hashCode());
        hashCode = 31 * hashCode + (this.getLogPublishingOptions() == null ? 0 : this.getLogPublishingOptions().hashCode());
        hashCode = 31 * hashCode + (this.getServiceSoftwareOptions() == null ? 0 : this.getServiceSoftwareOptions().hashCode());
        hashCode = 31 * hashCode + (this.getDomainEndpointOptions() == null ? 0 : this.getDomainEndpointOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAdvancedSecurityOptions() == null ? 0 : this.getAdvancedSecurityOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAutoTuneOptions() == null ? 0 : this.getAutoTuneOptions().hashCode());
        hashCode = 31 * hashCode + (this.getChangeProgressDetails() == null ? 0 : this.getChangeProgressDetails().hashCode());
        return hashCode;
    }

    public DomainStatus clone() {
        try {
            return (DomainStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

