/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.opensdk.protect.auth;

import com.amazonaws.auth.RequestSigner;
import com.amazonaws.opensdk.protect.auth.RequestSignerProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class RequestSignerRegistry
implements RequestSignerProvider {
    private final Map<Class<? extends RequestSigner>, RequestSigner> signerForType;

    public RequestSignerRegistry() {
        this.signerForType = Collections.emptyMap();
    }

    private RequestSignerRegistry(Map<Class<? extends RequestSigner>, RequestSigner> registeredSignersMap) {
        this.signerForType = Collections.unmodifiableMap(registeredSignersMap);
    }

    public RequestSignerRegistry register(RequestSigner requestSigner, Class<? extends RequestSigner> signerType) {
        HashMap<Class<? extends RequestSigner>, RequestSigner> registeredSigners = new HashMap<Class<? extends RequestSigner>, RequestSigner>();
        registeredSigners.putAll(this.signerForType);
        registeredSigners.put(signerType, requestSigner);
        return new RequestSignerRegistry(registeredSigners);
    }

    @Override
    public Optional<RequestSigner> getSigner(Class<? extends RequestSigner> requestSignerType) {
        return Optional.ofNullable(this.signerForType.get(requestSignerType));
    }
}

