/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;
import com.amazonaws.services.omics.model.StartReferenceImportJobSourceItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartReferenceImportJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
SignerTypeAware {
    private String referenceStoreId;
    private String roleArn;
    private String clientToken;
    private List<StartReferenceImportJobSourceItem> sources;

    public void setReferenceStoreId(String referenceStoreId) {
        this.referenceStoreId = referenceStoreId;
    }

    public String getReferenceStoreId() {
        return this.referenceStoreId;
    }

    public StartReferenceImportJobRequest withReferenceStoreId(String referenceStoreId) {
        this.setReferenceStoreId(referenceStoreId);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public StartReferenceImportJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartReferenceImportJobRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<StartReferenceImportJobSourceItem> getSources() {
        return this.sources;
    }

    public void setSources(Collection<StartReferenceImportJobSourceItem> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new ArrayList<StartReferenceImportJobSourceItem>(sources);
    }

    public StartReferenceImportJobRequest withSources(StartReferenceImportJobSourceItem ... sources) {
        if (this.sources == null) {
            this.setSources(new ArrayList<StartReferenceImportJobSourceItem>(sources.length));
        }
        for (StartReferenceImportJobSourceItem ele : sources) {
            this.sources.add(ele);
        }
        return this;
    }

    public StartReferenceImportJobRequest withSources(Collection<StartReferenceImportJobSourceItem> sources) {
        this.setSources(sources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReferenceStoreId() != null) {
            sb.append("ReferenceStoreId: ").append(this.getReferenceStoreId()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReferenceImportJobRequest)) {
            return false;
        }
        StartReferenceImportJobRequest other = (StartReferenceImportJobRequest)obj;
        if (other.getReferenceStoreId() == null ^ this.getReferenceStoreId() == null) {
            return false;
        }
        if (other.getReferenceStoreId() != null && !other.getReferenceStoreId().equals(this.getReferenceStoreId())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        return other.getSources() == null || other.getSources().equals(this.getSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReferenceStoreId() == null ? 0 : this.getReferenceStoreId().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        return hashCode;
    }

    public StartReferenceImportJobRequest clone() {
        return (StartReferenceImportJobRequest)super.clone();
    }

    public String getSignerType() {
        return "AWS4SignerType";
    }
}

