/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.SignerTypeAware;
import com.amazonaws.services.omics.model.AnnotationImportItemSource;
import com.amazonaws.services.omics.model.FormatOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartAnnotationImportJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
SignerTypeAware {
    private String destinationName;
    private String roleArn;
    private List<AnnotationImportItemSource> items;
    private String versionName;
    private FormatOptions formatOptions;
    private Boolean runLeftNormalization;
    private Map<String, String> annotationFields;

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public StartAnnotationImportJobRequest withDestinationName(String destinationName) {
        this.setDestinationName(destinationName);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public StartAnnotationImportJobRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<AnnotationImportItemSource> getItems() {
        return this.items;
    }

    public void setItems(Collection<AnnotationImportItemSource> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        this.items = new ArrayList<AnnotationImportItemSource>(items);
    }

    public StartAnnotationImportJobRequest withItems(AnnotationImportItemSource ... items) {
        if (this.items == null) {
            this.setItems(new ArrayList<AnnotationImportItemSource>(items.length));
        }
        for (AnnotationImportItemSource ele : items) {
            this.items.add(ele);
        }
        return this;
    }

    public StartAnnotationImportJobRequest withItems(Collection<AnnotationImportItemSource> items) {
        this.setItems(items);
        return this;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public StartAnnotationImportJobRequest withVersionName(String versionName) {
        this.setVersionName(versionName);
        return this;
    }

    public void setFormatOptions(FormatOptions formatOptions) {
        this.formatOptions = formatOptions;
    }

    public FormatOptions getFormatOptions() {
        return this.formatOptions;
    }

    public StartAnnotationImportJobRequest withFormatOptions(FormatOptions formatOptions) {
        this.setFormatOptions(formatOptions);
        return this;
    }

    public void setRunLeftNormalization(Boolean runLeftNormalization) {
        this.runLeftNormalization = runLeftNormalization;
    }

    public Boolean getRunLeftNormalization() {
        return this.runLeftNormalization;
    }

    public StartAnnotationImportJobRequest withRunLeftNormalization(Boolean runLeftNormalization) {
        this.setRunLeftNormalization(runLeftNormalization);
        return this;
    }

    public Boolean isRunLeftNormalization() {
        return this.runLeftNormalization;
    }

    public Map<String, String> getAnnotationFields() {
        return this.annotationFields;
    }

    public void setAnnotationFields(Map<String, String> annotationFields) {
        this.annotationFields = annotationFields;
    }

    public StartAnnotationImportJobRequest withAnnotationFields(Map<String, String> annotationFields) {
        this.setAnnotationFields(annotationFields);
        return this;
    }

    public StartAnnotationImportJobRequest addAnnotationFieldsEntry(String key, String value) {
        if (null == this.annotationFields) {
            this.annotationFields = new HashMap<String, String>();
        }
        if (this.annotationFields.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.annotationFields.put(key, value);
        return this;
    }

    public StartAnnotationImportJobRequest clearAnnotationFieldsEntries() {
        this.annotationFields = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinationName() != null) {
            sb.append("DestinationName: ").append(this.getDestinationName()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getItems() != null) {
            sb.append("Items: ").append(this.getItems()).append(",");
        }
        if (this.getVersionName() != null) {
            sb.append("VersionName: ").append(this.getVersionName()).append(",");
        }
        if (this.getFormatOptions() != null) {
            sb.append("FormatOptions: ").append(this.getFormatOptions()).append(",");
        }
        if (this.getRunLeftNormalization() != null) {
            sb.append("RunLeftNormalization: ").append(this.getRunLeftNormalization()).append(",");
        }
        if (this.getAnnotationFields() != null) {
            sb.append("AnnotationFields: ").append(this.getAnnotationFields());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAnnotationImportJobRequest)) {
            return false;
        }
        StartAnnotationImportJobRequest other = (StartAnnotationImportJobRequest)obj;
        if (other.getDestinationName() == null ^ this.getDestinationName() == null) {
            return false;
        }
        if (other.getDestinationName() != null && !other.getDestinationName().equals(this.getDestinationName())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getVersionName() == null ^ this.getVersionName() == null) {
            return false;
        }
        if (other.getVersionName() != null && !other.getVersionName().equals(this.getVersionName())) {
            return false;
        }
        if (other.getFormatOptions() == null ^ this.getFormatOptions() == null) {
            return false;
        }
        if (other.getFormatOptions() != null && !other.getFormatOptions().equals(this.getFormatOptions())) {
            return false;
        }
        if (other.getRunLeftNormalization() == null ^ this.getRunLeftNormalization() == null) {
            return false;
        }
        if (other.getRunLeftNormalization() != null && !other.getRunLeftNormalization().equals(this.getRunLeftNormalization())) {
            return false;
        }
        if (other.getAnnotationFields() == null ^ this.getAnnotationFields() == null) {
            return false;
        }
        return other.getAnnotationFields() == null || other.getAnnotationFields().equals(this.getAnnotationFields());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinationName() == null ? 0 : this.getDestinationName().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getVersionName() == null ? 0 : this.getVersionName().hashCode());
        hashCode = 31 * hashCode + (this.getFormatOptions() == null ? 0 : this.getFormatOptions().hashCode());
        hashCode = 31 * hashCode + (this.getRunLeftNormalization() == null ? 0 : this.getRunLeftNormalization().hashCode());
        hashCode = 31 * hashCode + (this.getAnnotationFields() == null ? 0 : this.getAnnotationFields().hashCode());
        return hashCode;
    }

    public StartAnnotationImportJobRequest clone() {
        return (StartAnnotationImportJobRequest)super.clone();
    }

    public String getSignerType() {
        return "AWS4SignerType";
    }
}

