/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.omics.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.omics.model.transform.SequenceInformationMarshaller;
import java.io.Serializable;

public class SequenceInformation
implements Serializable,
Cloneable,
StructuredPojo {
    private String alignment;
    private String generatedFrom;
    private Long totalBaseCount;
    private Long totalReadCount;

    public void setAlignment(String alignment) {
        this.alignment = alignment;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public SequenceInformation withAlignment(String alignment) {
        this.setAlignment(alignment);
        return this;
    }

    public void setGeneratedFrom(String generatedFrom) {
        this.generatedFrom = generatedFrom;
    }

    public String getGeneratedFrom() {
        return this.generatedFrom;
    }

    public SequenceInformation withGeneratedFrom(String generatedFrom) {
        this.setGeneratedFrom(generatedFrom);
        return this;
    }

    public void setTotalBaseCount(Long totalBaseCount) {
        this.totalBaseCount = totalBaseCount;
    }

    public Long getTotalBaseCount() {
        return this.totalBaseCount;
    }

    public SequenceInformation withTotalBaseCount(Long totalBaseCount) {
        this.setTotalBaseCount(totalBaseCount);
        return this;
    }

    public void setTotalReadCount(Long totalReadCount) {
        this.totalReadCount = totalReadCount;
    }

    public Long getTotalReadCount() {
        return this.totalReadCount;
    }

    public SequenceInformation withTotalReadCount(Long totalReadCount) {
        this.setTotalReadCount(totalReadCount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAlignment() != null) {
            sb.append("Alignment: ").append(this.getAlignment()).append(",");
        }
        if (this.getGeneratedFrom() != null) {
            sb.append("GeneratedFrom: ").append(this.getGeneratedFrom()).append(",");
        }
        if (this.getTotalBaseCount() != null) {
            sb.append("TotalBaseCount: ").append(this.getTotalBaseCount()).append(",");
        }
        if (this.getTotalReadCount() != null) {
            sb.append("TotalReadCount: ").append(this.getTotalReadCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceInformation)) {
            return false;
        }
        SequenceInformation other = (SequenceInformation)obj;
        if (other.getAlignment() == null ^ this.getAlignment() == null) {
            return false;
        }
        if (other.getAlignment() != null && !other.getAlignment().equals(this.getAlignment())) {
            return false;
        }
        if (other.getGeneratedFrom() == null ^ this.getGeneratedFrom() == null) {
            return false;
        }
        if (other.getGeneratedFrom() != null && !other.getGeneratedFrom().equals(this.getGeneratedFrom())) {
            return false;
        }
        if (other.getTotalBaseCount() == null ^ this.getTotalBaseCount() == null) {
            return false;
        }
        if (other.getTotalBaseCount() != null && !other.getTotalBaseCount().equals(this.getTotalBaseCount())) {
            return false;
        }
        if (other.getTotalReadCount() == null ^ this.getTotalReadCount() == null) {
            return false;
        }
        return other.getTotalReadCount() == null || other.getTotalReadCount().equals(this.getTotalReadCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAlignment() == null ? 0 : this.getAlignment().hashCode());
        hashCode = 31 * hashCode + (this.getGeneratedFrom() == null ? 0 : this.getGeneratedFrom().hashCode());
        hashCode = 31 * hashCode + (this.getTotalBaseCount() == null ? 0 : this.getTotalBaseCount().hashCode());
        hashCode = 31 * hashCode + (this.getTotalReadCount() == null ? 0 : this.getTotalReadCount().hashCode());
        return hashCode;
    }

    public SequenceInformation clone() {
        try {
            return (SequenceInformation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SequenceInformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

