/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.nimblestudio.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateStreamingImageResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private StreamingImage streamingImage;

    /**
     * @param streamingImage
     */

    public void setStreamingImage(StreamingImage streamingImage) {
        this.streamingImage = streamingImage;
    }

    /**
     * @return
     */

    public StreamingImage getStreamingImage() {
        return this.streamingImage;
    }

    /**
     * @param streamingImage
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateStreamingImageResult withStreamingImage(StreamingImage streamingImage) {
        setStreamingImage(streamingImage);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStreamingImage() != null)
            sb.append("StreamingImage: ").append(getStreamingImage());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateStreamingImageResult == false)
            return false;
        UpdateStreamingImageResult other = (UpdateStreamingImageResult) obj;
        if (other.getStreamingImage() == null ^ this.getStreamingImage() == null)
            return false;
        if (other.getStreamingImage() != null && other.getStreamingImage().equals(this.getStreamingImage()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStreamingImage() == null) ? 0 : getStreamingImage().hashCode());
        return hashCode;
    }

    @Override
    public UpdateStreamingImageResult clone() {
        try {
            return (UpdateStreamingImageResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
