/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.networkmanager.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.networkmanager.model.NetworkResourceSummary;
import com.amazonaws.services.networkmanager.model.transform.PathComponentMarshaller;
import java.io.Serializable;

public class PathComponent
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer sequence;
    private NetworkResourceSummary resource;
    private String destinationCidrBlock;

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public Integer getSequence() {
        return this.sequence;
    }

    public PathComponent withSequence(Integer sequence) {
        this.setSequence(sequence);
        return this;
    }

    public void setResource(NetworkResourceSummary resource) {
        this.resource = resource;
    }

    public NetworkResourceSummary getResource() {
        return this.resource;
    }

    public PathComponent withResource(NetworkResourceSummary resource) {
        this.setResource(resource);
        return this;
    }

    public void setDestinationCidrBlock(String destinationCidrBlock) {
        this.destinationCidrBlock = destinationCidrBlock;
    }

    public String getDestinationCidrBlock() {
        return this.destinationCidrBlock;
    }

    public PathComponent withDestinationCidrBlock(String destinationCidrBlock) {
        this.setDestinationCidrBlock(destinationCidrBlock);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSequence() != null) {
            sb.append("Sequence: ").append(this.getSequence()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getDestinationCidrBlock() != null) {
            sb.append("DestinationCidrBlock: ").append(this.getDestinationCidrBlock());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathComponent)) {
            return false;
        }
        PathComponent other = (PathComponent)obj;
        if (other.getSequence() == null ^ this.getSequence() == null) {
            return false;
        }
        if (other.getSequence() != null && !other.getSequence().equals(this.getSequence())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getDestinationCidrBlock() == null ^ this.getDestinationCidrBlock() == null) {
            return false;
        }
        return other.getDestinationCidrBlock() == null || other.getDestinationCidrBlock().equals(this.getDestinationCidrBlock());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSequence() == null ? 0 : this.getSequence().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationCidrBlock() == null ? 0 : this.getDestinationCidrBlock().hashCode());
        return hashCode;
    }

    public PathComponent clone() {
        try {
            return (PathComponent)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PathComponentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

