/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.networkmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Provides details about an error in a core network policy.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/CoreNetworkPolicyError"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CoreNetworkPolicyError implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The error code associated with a core network policy error.
     * </p>
     */
    private String errorCode;
    /**
     * <p>
     * The message associated with a core network policy error code.
     * </p>
     */
    private String message;
    /**
     * <p>
     * The JSON path where the error was discovered in the policy document.
     * </p>
     */
    private String path;

    /**
     * <p>
     * The error code associated with a core network policy error.
     * </p>
     * 
     * @param errorCode
     *        The error code associated with a core network policy error.
     */

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * <p>
     * The error code associated with a core network policy error.
     * </p>
     * 
     * @return The error code associated with a core network policy error.
     */

    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * <p>
     * The error code associated with a core network policy error.
     * </p>
     * 
     * @param errorCode
     *        The error code associated with a core network policy error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CoreNetworkPolicyError withErrorCode(String errorCode) {
        setErrorCode(errorCode);
        return this;
    }

    /**
     * <p>
     * The message associated with a core network policy error code.
     * </p>
     * 
     * @param message
     *        The message associated with a core network policy error code.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * The message associated with a core network policy error code.
     * </p>
     * 
     * @return The message associated with a core network policy error code.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * The message associated with a core network policy error code.
     * </p>
     * 
     * @param message
     *        The message associated with a core network policy error code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CoreNetworkPolicyError withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * <p>
     * The JSON path where the error was discovered in the policy document.
     * </p>
     * 
     * @param path
     *        The JSON path where the error was discovered in the policy document.
     */

    public void setPath(String path) {
        this.path = path;
    }

    /**
     * <p>
     * The JSON path where the error was discovered in the policy document.
     * </p>
     * 
     * @return The JSON path where the error was discovered in the policy document.
     */

    public String getPath() {
        return this.path;
    }

    /**
     * <p>
     * The JSON path where the error was discovered in the policy document.
     * </p>
     * 
     * @param path
     *        The JSON path where the error was discovered in the policy document.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CoreNetworkPolicyError withPath(String path) {
        setPath(path);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getErrorCode() != null)
            sb.append("ErrorCode: ").append(getErrorCode()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage()).append(",");
        if (getPath() != null)
            sb.append("Path: ").append(getPath());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CoreNetworkPolicyError == false)
            return false;
        CoreNetworkPolicyError other = (CoreNetworkPolicyError) obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null)
            return false;
        if (other.getErrorCode() != null && other.getErrorCode().equals(this.getErrorCode()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        if (other.getPath() == null ^ this.getPath() == null)
            return false;
        if (other.getPath() != null && other.getPath().equals(this.getPath()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getErrorCode() == null) ? 0 : getErrorCode().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        hashCode = prime * hashCode + ((getPath() == null) ? 0 : getPath().hashCode());
        return hashCode;
    }

    @Override
    public CoreNetworkPolicyError clone() {
        try {
            return (CoreNetworkPolicyError) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.networkmanager.model.transform.CoreNetworkPolicyErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
